/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.jftp.LocaleCellRenderer;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LocalePrefsPanel
extends JPanel
implements ActionListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.LocalePrefsPanel");
    private MComboBox comboLocales = null;
    private JRadioButton radioDateFormatShort = null;
    private JRadioButton radioDateFormatMedium = null;
    private JRadioButton radioTimeFormatShort = null;
    private JRadioButton radioTimeFormatMedium = null;
    private MLabel labPreviewDateFormat = null;
    private MLabel labPreviewTimeFormat = null;

    public LocalePrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
    }

    public boolean validateFields() {
        return true;
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void populateScreen(JFTPPreferences prefs) {
        this.comboLocales.setSelectedItem(Locale.getDefault());
        if (prefs.getDateFormat() == 3) {
            this.radioDateFormatShort.setSelected(true);
        } else {
            this.radioDateFormatMedium.setSelected(true);
        }
        if (prefs.getTimeFormat() == 3) {
            this.radioTimeFormatShort.setSelected(true);
        } else {
            this.radioTimeFormatMedium.setSelected(true);
        }
        this.updatePreview();
    }

    public void saveChanges() {
        JFTP.prefs.setLocale((Locale)this.comboLocales.getSelectedItem());
        if (this.radioDateFormatShort.isSelected()) {
            JFTP.prefs.setDateFormat(3);
        } else {
            JFTP.prefs.setDateFormat(2);
        }
        if (this.radioTimeFormatShort.isSelected()) {
            JFTP.prefs.setTimeFormat(3);
        } else {
            JFTP.prefs.setTimeFormat(2);
        }
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        MLabel labLocale = new MLabel(resources.getString("text.locale"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)labLocale, c);
        this.comboLocales = new MComboBox(Locale.getAvailableLocales());
        this.comboLocales.setRenderer(new LocaleCellRenderer());
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.comboLocales, c);
        MLabel labDateFormat = new MLabel(resources.getString("text.dateFormat"));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labDateFormat, c);
        this.radioDateFormatShort = new JRadioButton(resources.getString("text.short"));
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.radioDateFormatShort, c);
        this.radioDateFormatMedium = new JRadioButton(resources.getString("text.medium"));
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.radioDateFormatMedium, c);
        MLabel labPreview1 = new MLabel(resources.getString("text.preview"));
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labPreview1, c);
        this.labPreviewDateFormat = new MLabel();
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.labPreviewDateFormat, c);
        MLabel labTimeFormat = new MLabel(resources.getString("text.timeFormat"));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labTimeFormat, c);
        this.radioTimeFormatShort = new JRadioButton(resources.getString("text.short"));
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.radioTimeFormatShort, c);
        this.radioTimeFormatMedium = new JRadioButton(resources.getString("text.medium"));
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.radioTimeFormatMedium, c);
        MLabel labPreview2 = new MLabel(resources.getString("text.preview"));
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labPreview2, c);
        this.labPreviewTimeFormat = new MLabel();
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.labPreviewTimeFormat, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new MLabel(), c);
        ButtonGroup bgDate = new ButtonGroup();
        bgDate.add(this.radioDateFormatShort);
        bgDate.add(this.radioDateFormatMedium);
        ButtonGroup bgTime = new ButtonGroup();
        bgTime.add(this.radioTimeFormatShort);
        bgTime.add(this.radioTimeFormatMedium);
        this.populateScreen();
        this.comboLocales.addActionListener(this);
        this.radioDateFormatShort.addActionListener(this);
        this.radioDateFormatMedium.addActionListener(this);
        this.radioTimeFormatShort.addActionListener(this);
        this.radioTimeFormatMedium.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void updatePreview() {
        Locale selectedLocale = (Locale)this.comboLocales.getSelectedItem();
        DateFormat df = null;
        df = this.radioDateFormatShort.isSelected() ? DateFormat.getDateInstance(3, selectedLocale) : DateFormat.getDateInstance(2, selectedLocale);
        this.labPreviewDateFormat.setText(df.format(new Date()));
        df = this.radioTimeFormatShort.isSelected() ? DateFormat.getTimeInstance(3, selectedLocale) : DateFormat.getTimeInstance(2, selectedLocale);
        this.labPreviewTimeFormat.setText(df.format(new Date()));
    }
}

