/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;

public class NewRemoteFileDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.NewRemoteFileDlg");
    private static final String HELP_ID = "remote.newFile";
    private MTextField tfFile = null;
    private MButton butCreate = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private boolean approved = false;

    public NewRemoteFileDlg(Frame frame) {
        super(frame, resources.getString("title.dialog"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public String getFile() {
        if (this.approved) {
            return this.tfFile.getText();
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butCreate) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.close();
        } else if (evt.getSource() == this.butCancel) {
            this.close();
        }
    }

    private void close() {
        this.setVisible(false);
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private boolean validateInput() {
        String message = null;
        MTextField errorComponent = null;
        if (this.tfFile.getText().trim().length() == 0) {
            message = resources.getString("error.file.required");
            errorComponent = this.tfFile;
        }
        if (message != null) {
            GUIUtil.showError((Component)this, message);
            if (errorComponent != null) {
                ((Component)errorComponent).requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        MLabel labFile = new MLabel(resources.getString("text.file"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(12, 12, 11, 11);
        this.getContentPane().add((Component)labFile, c);
        this.tfFile = new MTextField(20);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(12, 0, 11, 11);
        this.getContentPane().add((Component)this.tfFile, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(6, 12, 11, 11);
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butCreate = new MButton(resources.getString("text.create"));
        this.butCreate.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butCreate);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butCreate);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

