/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPApplication;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXAdapter {
    private static Object macOSXApplication = null;
    private static JFTPApplication jftpApplication = null;
    private static MacOSXEventHandler eventHandler = null;

    public static void init(JFTPApplication jftpApplication) {
        OSXAdapter.jftpApplication = jftpApplication;
        OSXAdapter.createMacOSXApplication();
        if (macOSXApplication == null) {
            return;
        }
        eventHandler = new MacOSXEventHandler();
        OSXAdapter.handleDockIcon();
        OSXAdapter.registerQuitHandler();
        OSXAdapter.registerAboutHandler();
        OSXAdapter.registerPreferencesHandler();
    }

    private static void registerAboutHandler() {
        OSXAdapter.registerHandler("com.apple.eawt.AboutHandler", "setAboutHandler");
    }

    private static void registerQuitHandler() {
        OSXAdapter.registerHandler("com.apple.eawt.QuitHandler", "setQuitHandler");
    }

    private static void registerPreferencesHandler() {
        OSXAdapter.registerHandler("com.apple.eawt.PreferencesHandler", "setPreferencesHandler");
    }

    private static void registerHandler(String handlerClassName, String registrationMethodName) {
        try {
            Class<?> handlerClass = Class.forName(handlerClassName);
            Object proxy = Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{handlerClass}, (InvocationHandler)eventHandler);
            Method method = macOSXApplication.getClass().getMethod(registrationMethodName, handlerClass);
            method.invoke(macOSXApplication, proxy);
        }
        catch (Throwable t) {
            System.err.println("Unable to register event handler: " + handlerClassName);
            t.printStackTrace();
        }
    }

    public static void enableFullScreenMode(Window window) {
        if (macOSXApplication == null) {
            return;
        }
        try {
            Class<?> c = Class.forName("com.apple.eawt.FullScreenUtilities");
            Method method = c.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
            method.invoke(null, window, true);
        }
        catch (Throwable t) {
            System.err.println("Unable to set fullscreen mode for window");
            t.printStackTrace();
        }
    }

    private static void handleDockIcon() {
        try {
            Method method = macOSXApplication.getClass().getMethod("setDockIconImage", Image.class);
            Image image = Toolkit.getDefaultToolkit().getImage(JFTP.class.getResource("jftp128.gif"));
            method.invoke(macOSXApplication, image);
        }
        catch (Throwable t) {
            System.err.println("Unable to set the dock icon");
            t.printStackTrace();
        }
    }

    private static void createMacOSXApplication() {
        String applicationClassName = "com.apple.eawt.Application";
        try {
            Class<?> applicationClass = Class.forName(applicationClassName);
            Method method = applicationClass.getMethod("getApplication", new Class[0]);
            macOSXApplication = method.invoke(null, new Object[0]);
        }
        catch (Throwable exp) {
            System.err.println("Unable to get a reference to: " + applicationClassName);
            exp.printStackTrace();
        }
    }

    private static class MacOSXEventHandler
    implements InvocationHandler {
        private MacOSXEventHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("handleAbout".equals(method.getName())) {
                jftpApplication.showAboutDialog();
            } else if ("handlePreferences".equals(method.getName())) {
                jftpApplication.showPreferencesDialog();
            } else if ("handleQuitRequestWith".equals(method.getName())) {
                jftpApplication.quit();
            }
            return null;
        }
    }
}

