/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.IDTreeNode;
import com.myjavaworld.gui.ImageCellRenderer;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTree;
import com.myjavaworld.jftp.AdvancedConnectionPrefsPanel;
import com.myjavaworld.jftp.GeneralConnectionPrefsPanel;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.jftp.LocalePrefsPanel;
import com.myjavaworld.jftp.ProxyPrefsPanel;
import com.myjavaworld.jftp.SecurityPrefsPanel;
import com.myjavaworld.jftp.SoftwareUpdatePrefsPanel;
import com.myjavaworld.jftp.TransferModesPrefsPanel;
import com.myjavaworld.jftp.UIPrefsPanel;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class PreferencesDlg
extends MDialog
implements ActionListener,
TreeSelectionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.PreferencesDlg");
    private static final String HELP_ID = "preferences";
    private static final int ID_ROOT = 0;
    private static final int ID_CONNECTION = 0;
    private static final int ID_CONNECTION_GENERAL = 2;
    private static final int ID_CONNECTION_ADVANCED = 3;
    private static final int ID_CONNECTION_PROXY = 4;
    private static final int ID_CONNECTION_SECURITY = 5;
    private static final int ID_TRANSFER_MODES = 6;
    private static final int ID_REGIONAL_SETTINGS = 7;
    private static final int ID_UI = 8;
    private static final int ID_SOFTWARE_UPDATES = 9;
    JPanel centerPanel = null;
    private CardLayout cardLayout = null;
    private GeneralConnectionPrefsPanel generalConnectionPrefsPanel = null;
    private UIPrefsPanel uiPrefsPanel = null;
    private LocalePrefsPanel localePrefsPanel = null;
    private TransferModesPrefsPanel transferModesPrefsPanel = null;
    private AdvancedConnectionPrefsPanel advancedConnectionPrefsPanel = null;
    private ProxyPrefsPanel proxyPrefsPanel = null;
    private SecurityPrefsPanel securityPrefsPanel = null;
    private SoftwareUpdatePrefsPanel softwareUpdatePrefsPanel = null;
    private MTree tree = null;
    private MButton butSave = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private MButton butRestoreDefaults = null;

    public PreferencesDlg(JFTP jftp) {
        super(jftp, resources.getString("title.dialog"), true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butSave) {
            this.saveButtonPressed();
        } else if (evt.getSource() == this.butCancel) {
            this.setVisible(false);
        } else if (evt.getSource() == this.butRestoreDefaults) {
            JFTPPreferences defaultPreferences = new JFTPPreferences();
            this.generalConnectionPrefsPanel.populateScreen(defaultPreferences);
            this.advancedConnectionPrefsPanel.populateScreen(defaultPreferences);
            this.proxyPrefsPanel.populateScreen(defaultPreferences);
            this.securityPrefsPanel.populateScreen(defaultPreferences);
            this.transferModesPrefsPanel.populateScreen(defaultPreferences);
            this.localePrefsPanel.populateScreen(defaultPreferences);
            this.uiPrefsPanel.populateScreen(defaultPreferences);
            this.softwareUpdatePrefsPanel.populateScreen(defaultPreferences);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath selectedPath = evt.getPath();
        if (selectedPath == null) {
            return;
        }
        IDTreeNode selectedNode = (IDTreeNode)selectedPath.getLastPathComponent();
        String cardName = String.valueOf(selectedNode.getID());
        this.cardLayout.show(this.centerPanel, cardName);
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private MTree createTree() {
        IDTreeNode nodeRoot = new IDTreeNode(0, resources.getString("text.preferences"), true);
        IDTreeNode nodeRegionalSettings = new IDTreeNode(7, resources.getString("text.regionalSettings"), false);
        IDTreeNode nodeUISettings = new IDTreeNode(8, resources.getString("text.userInterface"), false);
        IDTreeNode nodeTransferModes = new IDTreeNode(6, resources.getString("text.transferModes"), false);
        IDTreeNode nodeSoftwareUpdates = new IDTreeNode(9, resources.getString("text.softwareUpdates"), false);
        IDTreeNode nodeConnectionSettings = new IDTreeNode(0, resources.getString("text.connectionSettings"), true);
        IDTreeNode nodeGeneral = new IDTreeNode(2, resources.getString("text.general"), false);
        IDTreeNode nodeAdvanced = new IDTreeNode(3, resources.getString("text.advanced"), false);
        IDTreeNode nodeProxy = new IDTreeNode(4, resources.getString("text.proxy"), false);
        IDTreeNode nodeSecurity = new IDTreeNode(5, resources.getString("text.security"), false);
        nodeConnectionSettings.add(nodeGeneral);
        nodeConnectionSettings.add(nodeAdvanced);
        nodeConnectionSettings.add(nodeProxy);
        nodeConnectionSettings.add(nodeSecurity);
        nodeRoot.add(nodeConnectionSettings);
        nodeRoot.add(nodeTransferModes);
        nodeRoot.add(nodeRegionalSettings);
        nodeRoot.add(nodeUISettings);
        nodeRoot.add(nodeSoftwareUpdates);
        MTree tree = new MTree(nodeRoot);
        tree.setCellRenderer(new ImageCellRenderer());
        tree.setShowsRootHandles(true);
        tree.setRootVisible(true);
        tree.expandRow(0);
        tree.expandRow(1);
        tree.expandRow(2);
        tree.getSelectionModel().setSelectionMode(1);
        int rowCount = tree.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        tree.setSelectionInterval(3, 3);
        return tree;
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.tree = this.createTree();
        MScrollPane treeScroller = new MScrollPane(this.tree);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getContentPane().add((Component)treeScroller, c);
        this.cardLayout = new CardLayout();
        this.centerPanel = new JPanel(this.cardLayout);
        this.localePrefsPanel = new LocalePrefsPanel();
        this.uiPrefsPanel = new UIPrefsPanel();
        this.transferModesPrefsPanel = new TransferModesPrefsPanel();
        this.generalConnectionPrefsPanel = new GeneralConnectionPrefsPanel();
        this.advancedConnectionPrefsPanel = new AdvancedConnectionPrefsPanel();
        this.proxyPrefsPanel = new ProxyPrefsPanel();
        this.securityPrefsPanel = new SecurityPrefsPanel();
        this.softwareUpdatePrefsPanel = new SoftwareUpdatePrefsPanel();
        MLabel labMessage = new MLabel(resources.getString("text.selectSubSection"));
        this.centerPanel.add("0", labMessage);
        this.centerPanel.add(String.valueOf(7), this.localePrefsPanel);
        this.centerPanel.add(String.valueOf(8), this.uiPrefsPanel);
        this.centerPanel.add(String.valueOf(6), this.transferModesPrefsPanel);
        this.centerPanel.add(String.valueOf(2), this.generalConnectionPrefsPanel);
        this.centerPanel.add(String.valueOf(3), this.advancedConnectionPrefsPanel);
        this.centerPanel.add(String.valueOf(4), this.proxyPrefsPanel);
        this.centerPanel.add(String.valueOf(5), this.securityPrefsPanel);
        this.centerPanel.add(String.valueOf(9), this.softwareUpdatePrefsPanel);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        this.getContentPane().add((Component)this.centerPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add(this.getCommandButtons(), c);
        this.tree.setSelectionInterval(2, 2);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butRestoreDefaults = new MButton(resources.getString("text.restoreDefaults"));
        this.butRestoreDefaults.addActionListener(this);
        this.butSave = new MButton(CommonResources.getString("text.save"));
        this.getRootPane().setDefaultButton(this.butSave);
        this.butSave.addActionListener(this);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butRestoreDefaults);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butSave);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        return panel;
    }

    private void saveButtonPressed() {
        if (!this.generalConnectionPrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(2, 2);
            return;
        }
        if (!this.advancedConnectionPrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(3, 3);
            return;
        }
        if (!this.proxyPrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(4, 4);
            return;
        }
        if (!this.securityPrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(5, 5);
            return;
        }
        if (!this.transferModesPrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(6, 6);
            return;
        }
        if (!this.localePrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(7, 7);
            return;
        }
        if (!this.uiPrefsPanel.validateFields()) {
            this.tree.setSelectionInterval(8, 8);
            return;
        }
        this.generalConnectionPrefsPanel.saveChanges();
        this.advancedConnectionPrefsPanel.saveChanges();
        this.proxyPrefsPanel.saveChanges();
        this.securityPrefsPanel.saveChanges();
        this.transferModesPrefsPanel.saveChanges();
        this.localePrefsPanel.saveChanges();
        this.uiPrefsPanel.saveChanges();
        this.softwareUpdatePrefsPanel.saveChanges();
        try {
            JFTP.savePreferences(JFTP.prefs);
            GUIUtil.showInformation(this, resources.getString("info.preferencesSaved"));
            Thread.sleep(200L);
        }
        catch (IOException exp) {
            GUIUtil.showError((Component)this, exp);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }
}

