/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.IntegerField;
import com.myjavaworld.gui.MCheckBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MPasswordField;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class ProxyPrefsPanel
extends JPanel
implements ActionListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ProxyPrefsPanel");
    private MCheckBox cbUseProxy = null;
    private MTextField tfHost = null;
    private IntegerField tfPort = null;
    private MTextField tfUser = null;
    private MPasswordField tfPassword = null;

    public ProxyPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
    }

    public void actionPerformed(ActionEvent evt) {
        this.setProxySettingsEnabled(this.cbUseProxy.isSelected());
    }

    private void setProxySettingsEnabled(boolean enabled) {
        this.tfHost.setEnabled(enabled);
        this.tfPort.setEnabled(enabled);
        this.tfUser.setEnabled(enabled);
        this.tfPassword.setEnabled(enabled);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MLabel labHost = new MLabel(resources.getString("text.host"));
        MLabel labPort = new MLabel(resources.getString("text.port"));
        MLabel labUser = new MLabel(resources.getString("text.user"));
        MLabel labPassword = new MLabel(resources.getString("text.password"));
        this.cbUseProxy = new MCheckBox(resources.getString("text.useProxy"));
        this.tfHost = new MTextField(30);
        this.tfPort = new IntegerField(5);
        this.tfUser = new MTextField(20);
        this.tfPassword = new MPasswordField(20);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.cbUseProxy, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labHost, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfHost, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labPort, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfPort, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labUser, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfUser, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labPassword, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.tfPassword, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new MLabel(), c);
        this.cbUseProxy.addActionListener(this);
        this.populateScreen();
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void populateScreen(JFTPPreferences prefs) {
        this.setProxySettingsEnabled(prefs.isUseProxy());
        this.cbUseProxy.setSelected(prefs.isUseProxy());
        this.tfHost.setText(prefs.getProxyHost());
        this.tfPort.setValue(prefs.getProxyPort());
        this.tfUser.setText(prefs.getProxyUser());
        this.tfPassword.setText(new String(prefs.getProxyPassword()));
    }

    public boolean validateFields() {
        String error = null;
        Component errorComponent = null;
        if (this.cbUseProxy.isSelected()) {
            int port = -1;
            try {
                port = this.tfPort.getValue();
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
            if (this.tfHost.getText().trim().length() == 0) {
                error = resources.getString("error.host.required");
                errorComponent = this.tfHost;
            } else if (port < 0 || port > 65535) {
                error = resources.getString("error.port.invalid");
                errorComponent = this.tfPort;
            }
        }
        if (error == null) {
            return true;
        }
        GUIUtil.showError((Component)this, error);
        errorComponent.requestFocusInWindow();
        return false;
    }

    public void saveChanges() {
        JFTP.prefs.setUseProxy(this.cbUseProxy.isSelected());
        JFTP.prefs.setProxyHost(this.tfHost.getText());
        int port = 1080;
        try {
            port = this.tfPort.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JFTP.prefs.setProxyPort(port);
        JFTP.prefs.setProxyUser(this.tfUser.getText());
        JFTP.prefs.setProxyPassword(this.tfPassword.getPassword());
        JFTPUtil.updateProxySettings();
    }
}

