/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import java.util.Comparator;

public class RemoteFileComparator
implements Comparator {
    public static final int COMPARE_BY_NAME = 1;
    public static final int COMPARE_BY_TYPE = 2;
    public static final int COMPARE_BY_SIZE = 3;
    public static final int COMPARE_BY_DATE = 4;
    public static final int ASC_ORDER = 1;
    public static final int DESC_ORDER = 2;
    private int compareBy = 0;
    private int order = 0;

    public RemoteFileComparator() {
        this(1, 1);
    }

    public RemoteFileComparator(int compareBy) {
        this(compareBy, 1);
    }

    public RemoteFileComparator(int compareBy, int order) {
        this.setCompareBy(compareBy);
        this.setOrder(order);
    }

    public void setCompareBy(int compareBy) {
        this.compareBy = compareBy;
    }

    public int getCompareBy() {
        return this.compareBy;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public int compare(Object o1, Object o2) {
        RemoteFile r1 = (RemoteFile)o1;
        RemoteFile r2 = (RemoteFile)o2;
        if (this.compareBy == 1) {
            return this.compareByName(r1, r2);
        }
        if (this.compareBy == 3) {
            return this.compareBySize(r1, r2);
        }
        if (this.compareBy == 4) {
            return this.compareByDate(r1, r2);
        }
        return this.compareByType(r1, r2);
    }

    private int compareByName(RemoteFile r1, RemoteFile r2) {
        int retVal = 0;
        retVal = r1.isDirectory() && !r2.isDirectory() ? -1 : (!r1.isDirectory() && r2.isDirectory() ? 1 : r1.getName().toUpperCase().compareTo(r2.getName().toUpperCase()));
        return this.order == 1 ? retVal : -retVal;
    }

    private int compareBySize(RemoteFile r1, RemoteFile r2) {
        int retVal = 0;
        if (r1.isDirectory() && !r2.isDirectory()) {
            retVal = -1;
        } else if (!r1.isDirectory() && r2.isDirectory()) {
            retVal = 1;
        } else {
            if (r1.getSize() == r2.getSize()) {
                retVal = 0;
            } else {
                int n = retVal = r1.getSize() < r2.getSize() ? -1 : 1;
            }
            if (retVal == 0) {
                retVal = r1.getName().toUpperCase().compareTo(r2.getName().toUpperCase());
            }
        }
        return this.order == 1 ? retVal : -retVal;
    }

    private int compareByDate(RemoteFile r1, RemoteFile r2) {
        int retVal = 0;
        retVal = r1.isDirectory() && !r2.isDirectory() ? -1 : (!r1.isDirectory() && r2.isDirectory() ? 1 : (r1.getLastModified() == r2.getLastModified() ? 0 : (r1.getLastModified() < r2.getLastModified() ? -1 : 1)));
        return this.order == 1 ? retVal : -retVal;
    }

    private int compareByType(RemoteFile r1, RemoteFile r2) {
        int retVal = 0;
        if (r1.isDirectory() && !r2.isDirectory()) {
            retVal = -1;
        } else if (!r1.isDirectory() && r2.isDirectory()) {
            retVal = 1;
        } else {
            retVal = r1.getType().compareTo(r2.getType());
            if (retVal == 0) {
                retVal = r1.getName().toUpperCase().compareTo(r2.getName().toUpperCase());
            }
        }
        return this.order == 1 ? retVal : -retVal;
    }
}

