/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.FTPClient;
import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MCheckBox;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MLabelTextField;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class RemoteFilePropertiesDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.RemoteFilePropertiesDlg");
    private static final String HELP_ID = "remote.properties";
    private FTPClient client = null;
    private RemoteFile file = null;
    private RemoteFile newFile = null;
    private MLabelTextField tfFileName = null;
    private MLabelTextField tfSite = null;
    private MLabelTextField tfFullPath = null;
    private MLabelTextField tfType = null;
    private MLabelTextField tfSize = null;
    private MLabelTextField tfContents = null;
    private MLabelTextField tfLastModified = null;
    private MLabelTextField tfLinkCount = null;
    private MLabelTextField tfOwner = null;
    private MLabelTextField tfGroup = null;
    private MCheckBox cbOwnerRead = null;
    private MCheckBox cbOwnerWrite = null;
    private MCheckBox cbOwnerExecute = null;
    private MCheckBox cbGroupRead = null;
    private MCheckBox cbGroupWrite = null;
    private MCheckBox cbGroupExecute = null;
    private MCheckBox cbPublicRead = null;
    private MCheckBox cbPublicWrite = null;
    private MCheckBox cbPublicExecute = null;
    private MCheckBox cbRecursive = null;
    private MButton butOK = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private MessageFormat sizeFormatter = null;
    private MessageFormat contentsFormatter = null;
    private int dirCount = 0;
    private int fileCount = 0;
    private long totalSize = 0L;
    private boolean closing = false;
    private boolean approved = false;
    private Filter filter = null;

    public RemoteFilePropertiesDlg(Frame parent, FTPClient client, RemoteFile file, Filter filter) {
        super(parent, "", true);
        this.client = client;
        this.file = file;
        this.filter = filter;
        this.sizeFormatter = new MessageFormat(resources.getString("value.size"));
        this.contentsFormatter = new MessageFormat(resources.getString("value.contents"));
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.updateTitle();
        this.populateScreen();
        this.pack();
    }

    public RemoteFile getFile() {
        if (this.approved) {
            return this.newFile;
        }
        return null;
    }

    public boolean isRecursive() {
        return this.cbRecursive.isSelected();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butOK) {
            this.okButtonPressed();
        } else if (evt.getSource() == this.butCancel) {
            this.newFile = null;
            this.close();
        }
    }

    public void windowClosing(WindowEvent evt) {
        this.close();
    }

    public void windowOpened(WindowEvent evt) {
        if (this.file.isDirectory()) {
            this.start();
        }
    }

    private void start() {
        this.dirCount = -1;
        this.fileCount = 0;
        this.totalSize = 0L;
        this.closing = false;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    RemoteFile workingDir = RemoteFilePropertiesDlg.this.client.getWorkingDirectory();
                    RemoteFilePropertiesDlg.this.computeSizeAndContents(RemoteFilePropertiesDlg.this.file);
                    RemoteFilePropertiesDlg.this.client.setWorkingDirectory(workingDir);
                }
                catch (Exception exp) {
                    System.err.println(exp);
                }
                return null;
            }

            public void finished() {
                RemoteFilePropertiesDlg.this.updateSizeAndContents();
            }
        };
        worker.start();
    }

    private void updateSizeAndContents() {
        String size = this.sizeFormatter.format(new Long[]{new Long(this.totalSize)});
        this.tfSize.setText(size);
        if (this.tfContents != null) {
            String contents = this.contentsFormatter.format(new Long[]{new Long(this.dirCount), new Long(this.fileCount)});
            this.tfContents.setText(contents);
        }
    }

    private void computeSizeAndContents(RemoteFile file) {
        if (this.closing) {
            return;
        }
        if (file.getName().equals(".") || file.getName().equals("..")) {
            return;
        }
        if (file.isFile()) {
            ++this.fileCount;
            this.totalSize += file.getSize();
        } else if (file.isDirectory()) {
            if (this.closing) {
                return;
            }
            ++this.dirCount;
            this.totalSize += file.getSize();
            try {
                this.client.setWorkingDirectory(file);
                RemoteFile[] children = this.client.list(this.filter);
                if (children == null) {
                    return;
                }
                for (int i = 0; i < children.length; ++i) {
                    this.computeSizeAndContents(children[i]);
                }
                this.updateSizeAndContents();
            }
            catch (Exception exp) {
                System.err.println(exp);
            }
        }
    }

    private void okButtonPressed() {
        this.approved = true;
        String newFileName = this.tfFileName.getText().trim();
        String attributes = "";
        String oldAttributes = this.file.getAttributes();
        if (oldAttributes.length() == 10) {
            attributes = attributes + oldAttributes.charAt(0);
            attributes = attributes + (this.cbOwnerRead.isSelected() ? (char)'r' : '-');
            attributes = attributes + (this.cbOwnerWrite.isSelected() ? (char)'w' : '-');
            attributes = attributes + (this.cbOwnerExecute.isSelected() ? (char)'x' : '-');
            attributes = attributes + (this.cbGroupRead.isSelected() ? (char)'r' : '-');
            attributes = attributes + (this.cbGroupWrite.isSelected() ? (char)'w' : '-');
            attributes = attributes + (this.cbGroupExecute.isSelected() ? (char)'x' : '-');
            attributes = attributes + (this.cbPublicRead.isSelected() ? (char)'r' : '-');
            attributes = attributes + (this.cbPublicWrite.isSelected() ? (char)'w' : '-');
            attributes = attributes + (this.cbPublicExecute.isSelected() ? (char)'x' : '-');
        }
        this.newFile = this.client.getListParser().createRemoteFile(newFileName);
        this.newFile.setAttributes(attributes);
        this.close();
    }

    private void populateScreen() {
        this.tfFileName.setText(this.file.getName());
        this.tfSite.setText(this.client.getRemoteHost());
        this.tfFullPath.setText(this.file.getPath());
        this.tfType.setText(this.file.getType());
        String size = this.sizeFormatter.format(new Long[]{new Long(this.file.getSize())});
        this.tfSize.setText(size);
        DateFormat df = DateFormat.getDateTimeInstance(0, 2);
        Date lastModified = new Date(this.file.getLastModified());
        this.tfLastModified.setText(df.format(lastModified));
        String linkCount = NumberFormat.getInstance().format(this.file.getLinkCount());
        this.tfLinkCount.setText(linkCount);
        this.tfOwner.setText(this.file.getOwner());
        this.tfGroup.setText(this.file.getGroup());
    }

    protected void escape() {
        this.close();
    }

    private void updateTitle() {
        MessageFormat titleFormatter = new MessageFormat(resources.getString("title.dialog"));
        String title = titleFormatter.format(new Object[]{this.file.getName()});
        this.setTitle(title);
    }

    private void close() {
        this.closing = true;
        this.setVisible(false);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        int row = 0;
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        MLabel labIcon = new MLabel();
        labIcon.setHorizontalAlignment(2);
        if (this.file.isDirectory()) {
            labIcon.setIcon(JFTPUtil.getIcon("directory16.gif"));
        } else if (this.file.isFile()) {
            labIcon.setIcon(JFTPUtil.getIcon("file16.gif"));
        }
        this.getContentPane().add((Component)labIcon, c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.tfFileName = new MLabelTextField(30);
        this.getContentPane().add((Component)this.tfFileName, c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new JSeparator(0), c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.site")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfSite = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfSite, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.fullPath")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfFullPath = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfFullPath, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.type")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfType = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfType, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.size")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfSize = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfSize, c);
        if (this.file.isDirectory()) {
            c.gridx = 0;
            c.gridy = row;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 12, 12, 12);
            this.getContentPane().add((Component)new MLabel(resources.getString("text.contents")), c);
            c.gridx = 1;
            c.gridy = row++;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(0, 0, 12, 12);
            this.tfContents = new MLabelTextField(20);
            this.getContentPane().add((Component)this.tfContents, c);
        }
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.lastModified")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfLastModified = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfLastModified, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.links")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfLinkCount = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfLinkCount, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.owner")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfOwner = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfOwner, c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(resources.getString("text.group")), c);
        c.gridx = 1;
        c.gridy = row++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.tfGroup = new MLabelTextField(20);
        this.getContentPane().add((Component)this.tfGroup, c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getAttributesPanel(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)new MLabel(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(6, 12, 11, 11);
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getAttributesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("title.attributes")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        String attributes = this.file.getAttributes();
        boolean ownerRead = false;
        boolean ownerWrite = false;
        boolean ownerExecute = false;
        boolean groupRead = false;
        boolean groupWrite = false;
        boolean groupExecute = false;
        boolean publicRead = false;
        boolean publicWrite = false;
        boolean publicExecute = false;
        if (attributes.length() == 10) {
            ownerRead = attributes.charAt(1) == 'r';
            ownerWrite = attributes.charAt(2) == 'w';
            ownerExecute = attributes.charAt(3) == 'x';
            groupRead = attributes.charAt(4) == 'r';
            groupWrite = attributes.charAt(5) == 'w';
            groupExecute = attributes.charAt(6) == 'x';
            publicRead = attributes.charAt(7) == 'r';
            publicWrite = attributes.charAt(8) == 'w';
            publicExecute = attributes.charAt(9) == 'x';
        }
        this.cbOwnerRead = new MCheckBox("", ownerRead);
        this.cbOwnerWrite = new MCheckBox("", ownerWrite);
        this.cbOwnerExecute = new MCheckBox("", ownerExecute);
        this.cbGroupRead = new MCheckBox("", groupRead);
        this.cbGroupWrite = new MCheckBox("", groupWrite);
        this.cbGroupExecute = new MCheckBox("", groupExecute);
        this.cbPublicRead = new MCheckBox("", publicRead);
        this.cbPublicWrite = new MCheckBox("", publicWrite);
        this.cbPublicExecute = new MCheckBox("", publicExecute);
        this.cbRecursive = new MCheckBox(resources.getString("text.recursive"), false);
        if (!this.file.isDirectory()) {
            this.cbRecursive.setEnabled(false);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)new MLabel(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)new MLabel(resources.getString("text.read")), c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)new MLabel(resources.getString("text.write")), c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)new MLabel(resources.getString("text.execute")), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)new MLabel(resources.getString("text.owner")), c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbOwnerRead, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbOwnerWrite, c);
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbOwnerExecute, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)new MLabel(resources.getString("text.group")), c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbGroupRead, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbGroupWrite, c);
        c.gridx = 3;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbGroupExecute, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)new MLabel(resources.getString("text.public")), c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbPublicRead, c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbPublicWrite, c);
        c.gridx = 3;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.cbPublicExecute, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.cbRecursive, c);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butOK = new MButton(CommonResources.getString("text.ok"));
        this.butOK.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butOK);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butOK);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

