/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.util.ResourceLoader;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class RemoteFileTableModel
extends AbstractTableModel {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.RemoteFileTableModel");
    private static final String[] COLUMN_NAMES = new String[]{resources.getString("text.name"), resources.getString("text.type"), resources.getString("text.size"), resources.getString("text.lastModified"), resources.getString("text.attributes")};
    private RemoteFile[] data = null;

    public RemoteFileTableModel() {
        this(new RemoteFile[0]);
    }

    public RemoteFileTableModel(RemoteFile[] data) {
        this.setData(data);
    }

    public void setData(RemoteFile[] data) {
        if (data == null) {
            data = new RemoteFile[]{};
        }
        this.data = data;
        this.fireTableDataChanged();
    }

    public RemoteFile[] getData() {
        return this.data;
    }

    public RemoteFile getFileAt(int row) {
        return this.data[row];
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.data[row];
        }
        if (col == 1) {
            return this.data[row].getType();
        }
        if (col == 2) {
            return new Long(this.data[row].getSize());
        }
        if (col == 3) {
            return new Date(this.data[row].getLastModified());
        }
        return this.data[row].getAttributes();
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return RemoteFile.class;
        }
        if (col == 2) {
            return Long.class;
        }
        if (col == 3) {
            return Date.class;
        }
        return Object.class;
    }
}

