/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class RemoteHost
implements Serializable,
Comparable {
    private static final long serialVersionUID = -3213664402994404410L;
    public static final String DEFAULT_FTP_CLIENT_CLASS_NAME = "com.myjavaworld.ftp.DefaultFTPClient";
    public static final String DEFAULT_LIST_PARSER_CLASS_NAME = "com.myjavaworld.ftp.DefaultListParser";
    protected String name = null;
    protected String hostName = null;
    protected int port = 0;
    protected String user = null;
    protected String password = null;
    protected String account = null;
    protected String ftpClientClassName = null;
    protected String listParserClassName = null;
    protected boolean passive = true;
    protected String[] commands = null;
    protected String initialLocalDirectory = null;
    protected String initialRemoteDirectory = null;
    protected int sslUsage = 0;
    protected boolean dataChannelUnencrypted = true;
    protected Integer implicitSSLPort = null;

    public RemoteHost() {
        this("", "", 21, "", "", "");
    }

    public RemoteHost(String hostName, String user, String password) {
        this(hostName, hostName, 21, user, password, "");
    }

    public RemoteHost(String hostName, int port, String user, String password, String account) {
        this(hostName, hostName, port, user, password, account);
    }

    public RemoteHost(String name, String hostName, int port, String user, String password, String account) {
        this.setName(name);
        this.setHostName(hostName);
        this.setPort(port);
        this.setUser(user);
        this.setPassword(password);
        this.setAccount(account);
        this.setFTPClientClassName(DEFAULT_FTP_CLIENT_CLASS_NAME);
        this.setListParserClassName(DEFAULT_LIST_PARSER_CLASS_NAME);
        this.initialLocalDirectory = "";
        this.initialRemoteDirectory = "";
        this.setPassive(true);
        this.setCommands(new String[0]);
        this.setSSLUsage(0);
        this.setDataChannelUnencrypted(false);
        this.setImplicitSSLPort(990);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName == null ? "" : hostName.trim();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(int port) {
        this.port = port <= 0 ? 21 : port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPassword(String password) {
        this.password = password == null ? "" : password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user == null ? "" : user;
    }

    public String getUser() {
        return this.user;
    }

    public void setAccount(String account) {
        this.account = account == null ? "" : account;
    }

    public String getAccount() {
        return this.account;
    }

    public void setFTPClientClassName(String ftpClientClassName) {
        this.ftpClientClassName = ftpClientClassName;
    }

    public String getFTPClientClassName() {
        return this.ftpClientClassName;
    }

    public void setListParserClassName(String listParserClassName) {
        this.listParserClassName = listParserClassName;
    }

    public String getListParserClassName() {
        return this.listParserClassName;
    }

    public void setCommands(String[] commands) {
        this.commands = commands;
    }

    public void setCommands(String commands) {
        StringTokenizer tokenizer = new StringTokenizer(commands, "\r\n");
        ArrayList<String> commandList = new ArrayList<String>(5);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.trim().length() <= 0) continue;
            commandList.add(token);
        }
        String[] commandArray = new String[commandList.size()];
        commandArray = commandList.toArray(commandArray);
        this.setCommands(commandArray);
    }

    public String[] getCommands() {
        return this.commands;
    }

    public String getCommandsAsString() {
        StringBuffer buffer = new StringBuffer(256);
        for (int i = 0; i < this.commands.length; ++i) {
            buffer.append(this.commands[i]);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setInitialLocalDirectory(String initialLocalDirectory) {
        this.initialLocalDirectory = initialLocalDirectory;
    }

    public String getInitialLocalDirectory() {
        return this.initialLocalDirectory;
    }

    public void setInitialRemoteDirectory(String initialRemoteDirectory) {
        this.initialRemoteDirectory = initialRemoteDirectory;
    }

    public String getInitialRemoteDirectory() {
        return this.initialRemoteDirectory;
    }

    public void setSSLUsage(int sslUsage) {
        this.sslUsage = sslUsage;
    }

    public int getSSLUsage() {
        return this.sslUsage;
    }

    public void setDataChannelUnencrypted(boolean dataChannelUnencrypted) {
        this.dataChannelUnencrypted = dataChannelUnencrypted;
    }

    public boolean isDataChannelUnencrypted() {
        return this.dataChannelUnencrypted;
    }

    public void setImplicitSSLPort(int implicitSSLPort) {
        this.implicitSSLPort = new Integer(implicitSSLPort);
    }

    public int getImplicitSSLPort() {
        if (this.implicitSSLPort != null) {
            return this.implicitSSLPort;
        }
        return 990;
    }

    public String toString() {
        if (this.name.trim().length() == 0) {
            return this.hostName;
        }
        return this.name + " [" + this.hostName + "]";
    }

    public int compareTo(Object obj) {
        RemoteHost that = (RemoteHost)obj;
        return this.name.toUpperCase().compareTo(that.name.toUpperCase());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RemoteHost)) {
            return false;
        }
        RemoteHost that = (RemoteHost)obj;
        return this.name.equals(that.name) && this.hostName.equals(that.hostName) && this.port == that.port && this.user.equals(that.user) && this.password.equals(that.password);
    }
}

