/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.DateCellRenderer;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTable;
import com.myjavaworld.gui.MTableCellRenderer;
import com.myjavaworld.gui.MTableHeaderRenderer;
import com.myjavaworld.gui.NumericCellRenderer;
import com.myjavaworld.jftp.DnDTransferHandler;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.jftp.RemoteFileCellRenderer;
import com.myjavaworld.jftp.RemoteFileComparator;
import com.myjavaworld.jftp.RemoteFileTableModel;
import com.myjavaworld.jftp.RemoteSystemPopupMenu;
import com.myjavaworld.jftp.actions.DeleteRemoteFileAction;
import com.myjavaworld.jftp.actions.OpenRemoteFileAction;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RemotePane
extends JPanel
implements ActionListener,
MouseListener,
ListSelectionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.RemotePane");
    private static final Icon UP_ARROW_ICON = JFTPUtil.getIcon("upArrow16.gif");
    private static final Icon DOWN_ARROW_ICON = JFTPUtil.getIcon("downArrow16.gif");
    private FTPSession session = null;
    private MComboBox comboWorkingDirectory = null;
    private MButton butUp = null;
    private RemoteFileTableModel model = null;
    private MTable table = null;
    private MScrollPane scroller = null;
    private MLabel labStatus = null;
    private RemoteFileComparator comparator = null;
    private boolean updateComboWorkingDirectory = true;
    private MessageFormat statusFormat1 = null;
    private MessageFormat statusFormat2 = null;
    private Object[] statusArgs = null;

    public RemotePane(FTPSession session) {
        this.session = session;
        this.comparator = new RemoteFileComparator();
        this.statusFormat1 = new MessageFormat(resources.getString("status.objectCount"));
        this.statusFormat2 = new MessageFormat(resources.getString("status.selectedObjectCount"));
        this.statusFormat1.setLocale(Locale.getDefault());
        this.statusFormat2.setLocale(Locale.getDefault());
        this.statusArgs = new Object[2];
        this.setLayout(new GridBagLayout());
        this.initComponents();
        this.configureTable();
        this.updateTableHeader();
    }

    public void setData(RemoteFile dir, RemoteFile[] data) {
        if (data == null) {
            data = new RemoteFile[]{};
        }
        Arrays.sort(data, this.comparator);
        this.model.setData(data);
        if (this.updateComboWorkingDirectory) {
            this.updateComboWorkingDirectory(dir);
        }
        if (data.length > 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(0, 0, true));
        }
        this.updateStatus();
    }

    public RemoteFile[] getData() {
        return this.model.getData();
    }

    public int getSelectionCount() {
        return this.table.getSelectedRowCount();
    }

    public RemoteFile getSelectedFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.model.getFileAt(row);
    }

    public RemoteFile[] getSelectedFiles() {
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows == null) {
            return new RemoteFile[0];
        }
        RemoteFile[] selectedFiles = new RemoteFile[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedFiles[i] = this.model.getFileAt(selectedRows[i]);
        }
        return selectedFiles;
    }

    public void refresh() {
        this.session.setRemoteWorkingDirectory(this.session.getRemoteWorkingDirectory());
    }

    public void clearAll() {
        this.comboWorkingDirectory.setModel(new DefaultComboBoxModel());
        this.model.setData(new RemoteFile[0]);
    }

    public void valueChanged(ListSelectionEvent evt) {
        this.updateStatus();
        this.session.updateToolBar();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butUp) {
            this.session.upRemoteWorkingDirectory();
        } else if (evt.getSource() == this.comboWorkingDirectory) {
            RemoteFile selectedFile = (RemoteFile)this.comboWorkingDirectory.getSelectedItem();
            this.updateComboWorkingDirectory = false;
            this.session.setRemoteWorkingDirectory(selectedFile);
            this.updateComboWorkingDirectory = true;
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (evt.getSource() == this.table) {
                this.tableRightClicked(evt);
            } else if (evt.getSource() == this.scroller) {
                this.scrollerRightClicked(evt);
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
        Cursor cursor;
        if (evt.isPopupTrigger()) {
            if (evt.getSource() == this.table) {
                this.tableRightClicked(evt);
            } else if (evt.getSource() == this.scroller) {
                this.scrollerRightClicked(evt);
            }
        } else if (evt.getSource() == this.table) {
            if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() >= 2) {
                this.doubleClicked(evt);
            }
        } else if (evt.getSource() == this.table.getTableHeader() && SwingUtilities.isLeftMouseButton(evt) && (cursor = this.table.getTableHeader().getCursor()).equals(Cursor.getPredefinedCursor(0))) {
            int column = this.table.columnAtPoint(evt.getPoint());
            if ((column = this.table.convertColumnIndexToModel(column)) < 4) {
                this.sort(column);
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    private void tableRightClicked(MouseEvent evt) {
        RemoteSystemPopupMenu popup = RemoteSystemPopupMenu.getInstance(this.session.getJFTP());
        ((JPopupMenu)popup).show((Component)evt.getSource(), evt.getX(), evt.getY());
    }

    private void scrollerRightClicked(MouseEvent evt) {
        this.table.clearSelection();
        RemoteSystemPopupMenu popup = RemoteSystemPopupMenu.getInstance(this.session.getJFTP());
        ((JPopupMenu)popup).show((Component)evt.getSource(), evt.getX(), evt.getY());
    }

    private void doubleClicked(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row < 0) {
            return;
        }
        RemoteFile file = this.model.getFileAt(row);
        if (file.isDirectory() || file.isLink()) {
            this.session.setRemoteWorkingDirectory(file);
        } else {
            OpenRemoteFileAction.getInstance(this.session.getJFTP()).actionPerformed(null);
        }
    }

    private void updateComboWorkingDirectory(RemoteFile dir) {
        this.comboWorkingDirectory.removeActionListener(this);
        int count = this.comboWorkingDirectory.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!dir.equals(this.comboWorkingDirectory.getItemAt(i))) continue;
            this.comboWorkingDirectory.setSelectedIndex(i);
            this.comboWorkingDirectory.addActionListener(this);
            return;
        }
        this.comboWorkingDirectory.insertItemAt(dir, 0);
        this.comboWorkingDirectory.setSelectedIndex(0);
        this.comboWorkingDirectory.addActionListener(this);
    }

    private void updateStatus() {
        long size = 0L;
        int count = this.table.getSelectedRowCount();
        if (count > 0) {
            int[] selectedRows = this.table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                size += this.model.getFileAt(selectedRows[i]).getSize();
            }
            this.statusArgs[0] = new Integer(count);
            this.statusArgs[1] = new Long(size);
            this.labStatus.setText(this.statusFormat2.format(this.statusArgs));
            return;
        }
        count = this.model.getRowCount();
        for (int i = 0; i < count; ++i) {
            size += this.model.getFileAt(i).getSize();
        }
        this.statusArgs[0] = new Integer(count);
        this.statusArgs[1] = new Long(size);
        this.labStatus.setText(this.statusFormat1.format(this.statusArgs));
    }

    private void sort(int col) {
        int compareBy = this.comparator.getCompareBy();
        int order = this.comparator.getOrder();
        if (compareBy == col + 1) {
            order = order == 1 ? 2 : 1;
        } else {
            compareBy = col + 1;
            order = 1;
        }
        this.comparator.setCompareBy(compareBy);
        this.comparator.setOrder(order);
        RemoteFile[] data = this.model.getData();
        Arrays.sort(this.model.getData(), this.comparator);
        this.model.setData(data);
        this.updateTableHeader();
    }

    private void updateTableHeader() {
        int compareBy = this.comparator.getCompareBy();
        int order = this.comparator.getOrder();
        Icon icon = order == 1 ? UP_ARROW_ICON : DOWN_ARROW_ICON;
        for (int i = 0; i < 4; ++i) {
            MTableHeaderRenderer r = new MTableHeaderRenderer();
            if (compareBy - 1 == i) {
                r.setIcon(icon);
            } else {
                r.setIcon(null);
            }
            this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(i)).setHeaderRenderer(r);
        }
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.comboWorkingDirectory = new MComboBox();
        this.comboWorkingDirectory.setToolTipText(resources.getString("tooltip.workingDirectory"));
        this.comboWorkingDirectory.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.comboWorkingDirectory, c);
        this.butUp = new MButton(JFTPUtil.getIcon("upDirectory16.gif"));
        this.butUp.setToolTipText(resources.getString("tooltip.up"));
        this.butUp.addActionListener(this);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.butUp, c);
        this.model = new RemoteFileTableModel();
        this.table = new MTable(this.model){

            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(0);
        this.scroller = new MScrollPane(this.table);
        if (this.table.isBackgroundSet()) {
            this.scroller.getViewport().setBackground(this.table.getBackground());
        }
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.scroller, c);
        this.labStatus = new MLabel(" ");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.labStatus, c);
    }

    private void configureTable() {
        this.table.setName("remotePane");
        this.scroller.setName("remotePane");
        DnDTransferHandler th = new DnDTransferHandler(this.session.getJFTP());
        this.table.setDragEnabled(true);
        this.scroller.setTransferHandler(th);
        this.table.setTransferHandler(th);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(100);
        int dateFormat = JFTP.prefs.getDateFormat();
        int timeFormat = JFTP.prefs.getTimeFormat();
        this.table.setDefaultRenderer(RemoteFile.class, new RemoteFileCellRenderer());
        this.table.setDefaultRenderer(Long.class, new NumericCellRenderer());
        this.table.setDefaultRenderer(Date.class, new DateCellRenderer(dateFormat, timeFormat));
        this.table.setDefaultRenderer(Object.class, new MTableCellRenderer());
        this.table.addMouseListener(this);
        this.scroller.addMouseListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getTableHeader().setDefaultRenderer(new MTableHeaderRenderer());
        this.table.getTableHeader().addMouseListener(this);
        this.table.registerKeyboardAction(DeleteRemoteFileAction.getInstance(this.session.getJFTP()), "cmd.deleteRemoteFile", KeyStroke.getKeyStroke(GUIUtil.getDeleteKey(), 0), 0);
        this.table.registerKeyboardAction(OpenRemoteFileAction.getInstance(this.session.getJFTP()), "cmd.openRemoteFile", KeyStroke.getKeyStroke(10, 0), 0);
    }

    public void selectAll() {
        this.table.selectAll();
    }

    public void invertSelection() {
        int rowCount = this.model.getRowCount();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        for (int i = 0; i < rowCount; ++i) {
            if (selectionModel.isSelectedIndex(i)) {
                selectionModel.removeSelectionInterval(i, i);
                continue;
            }
            selectionModel.addSelectionInterval(i, i);
        }
    }
}

