/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MMenu;
import com.myjavaworld.gui.MMenuItem;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.actions.ChangeRemoteDirectoryAction;
import com.myjavaworld.jftp.actions.DeleteRemoteFileAction;
import com.myjavaworld.jftp.actions.EditRemoteFileAction;
import com.myjavaworld.jftp.actions.NewRemoteDirectoryAction;
import com.myjavaworld.jftp.actions.NewRemoteFileAction;
import com.myjavaworld.jftp.actions.OpenRemoteFileAction;
import com.myjavaworld.jftp.actions.PrintRemoteFileAction;
import com.myjavaworld.jftp.actions.RenameRemoteFileAction;
import com.myjavaworld.util.ResourceLoader;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class RemoteSystemMenu
extends MMenu
implements MenuListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.RemoteSystemMenu");
    private static final ResourceBundle ftpMenuResources = ResourceLoader.getBundle("com.myjavaworld.jftp.FTPMenu");
    private JFTP jftp = null;
    private MMenuItem miFile = null;
    private MMenuItem miDirectory = null;
    private MMenuItem miChangeDirectory = null;
    private MMenuItem miRename = null;
    private MMenuItem miDelete = null;
    private MMenuItem miOpenFile;
    private MMenuItem miEditFile;
    private MMenuItem miPrintFile;
    private MMenu menuNew;
    private MMenu menuExecute;
    private MMenuItem miHelp;
    private MMenuItem miStat;
    private MMenuItem miSyst;
    private MMenuItem miNoop;
    private MMenuItem miOther;
    private MMenuItem miApplyFilter;
    private MMenuItem miClearFilter;
    private MMenuItem miRefresh;
    private MMenuItem miProperties;
    private MMenuItem miSelectAll = null;
    private MMenuItem miInvertSelection = null;

    public RemoteSystemMenu(JFTP jftp) {
        this.jftp = jftp;
        this.setText(resources.getString("text.remoteSystem"));
        this.setMnemonic(resources.getString("mnemonic.remoteSystem"), resources.getString("mnemonicIndex.remoteSystem"));
        this.prepareMenuItems();
        this.addMenuListener(this);
    }

    private void prepareMenuItems() {
        this.miOpenFile = new MMenuItem(resources.getString("text.open"));
        this.miOpenFile.setActionCommand("cmd.openRemoteFile");
        this.miOpenFile.setAccelerator(KeyStroke.getKeyStroke(79, GUIUtil.ACCELERATOR_MASK));
        this.miOpenFile.setMnemonic(resources.getString("mnemonic.open"), resources.getString("mnemonicIndex.open"));
        this.miOpenFile.addActionListener(OpenRemoteFileAction.getInstance(this.jftp));
        this.add(this.miOpenFile);
        this.miEditFile = new MMenuItem(resources.getString("text.edit"));
        this.miEditFile.setActionCommand("cmd.editRemoteFile");
        this.miEditFile.setAccelerator(KeyStroke.getKeyStroke(69, GUIUtil.ACCELERATOR_MASK));
        this.miEditFile.setMnemonic(resources.getString("mnemonic.edit"), resources.getString("mnemonicIndex.edit"));
        this.miEditFile.addActionListener(EditRemoteFileAction.getInstance(this.jftp));
        this.add(this.miEditFile);
        this.miPrintFile = new MMenuItem(resources.getString("text.print"));
        this.miPrintFile.setActionCommand("cmd.printRemoteFile");
        this.miPrintFile.setAccelerator(KeyStroke.getKeyStroke(80, GUIUtil.ACCELERATOR_MASK));
        this.miPrintFile.setMnemonic(resources.getString("mnemonic.print"), resources.getString("mnemonicIndex.print"));
        this.miPrintFile.addActionListener(PrintRemoteFileAction.getInstance(this.jftp));
        this.add(this.miPrintFile);
        this.addSeparator();
        this.menuNew = new MMenu(resources.getString("text.new"), true);
        this.menuNew.setMnemonic(resources.getString("mnemonic.new"), resources.getString("mnemonicIndex.new"));
        this.add(this.menuNew);
        this.miFile = new MMenuItem(resources.getString("text.file"));
        this.miFile.setAccelerator(KeyStroke.getKeyStroke(70, GUIUtil.ACCELERATOR_MASK));
        this.miFile.setMnemonic(resources.getString("mnemonic.file"), resources.getString("mnemonicIndex.file"));
        this.miFile.addActionListener(NewRemoteFileAction.getInstance(this.jftp));
        this.menuNew.add(this.miFile);
        this.miDirectory = new MMenuItem(resources.getString("text.directory"));
        this.miDirectory.setAccelerator(KeyStroke.getKeyStroke(68, GUIUtil.ACCELERATOR_MASK));
        this.miDirectory.setMnemonic(resources.getString("mnemonic.directory"), resources.getString("mnemonicIndex.directory"));
        this.miDirectory.addActionListener(NewRemoteDirectoryAction.getInstance(this.jftp));
        this.menuNew.add(this.miDirectory);
        this.miChangeDirectory = new MMenuItem(resources.getString("text.changeDirectory"));
        this.miChangeDirectory.setMnemonic(resources.getString("mnemonic.changeDirectory"), resources.getString("mnemonicIndex.changeDirectory"));
        this.miChangeDirectory.addActionListener(ChangeRemoteDirectoryAction.getInstance(this.jftp));
        this.add(this.miChangeDirectory);
        this.miRename = new MMenuItem(resources.getString("text.rename"));
        this.miRename.setAccelerator(KeyStroke.getKeyStroke(82, GUIUtil.ACCELERATOR_MASK));
        this.miRename.setMnemonic(resources.getString("mnemonic.rename"), resources.getString("mnemonicIndex.rename"));
        this.miRename.addActionListener(RenameRemoteFileAction.getInstance(this.jftp));
        this.add(this.miRename);
        this.miDelete = new MMenuItem(resources.getString("text.delete"));
        this.miDelete.setAccelerator(KeyStroke.getKeyStroke(GUIUtil.getDeleteKey(), GUIUtil.ACCELERATOR_MASK));
        this.miDelete.setMnemonic(resources.getString("mnemonic.delete"), resources.getString("mnemonicIndex.delete"));
        this.miDelete.addActionListener(DeleteRemoteFileAction.getInstance(this.jftp));
        this.add(this.miDelete);
        this.addSeparator();
        this.menuExecute = new MMenu(resources.getString("text.execute"), true);
        this.menuExecute.setMnemonic(resources.getString("mnemonic.execute"), resources.getString("mnemonicIndex.execute"));
        this.add(this.menuExecute);
        this.miHelp = new MMenuItem(resources.getString("text.help"));
        this.miHelp.setMnemonic(resources.getString("mnemonic.help"), resources.getString("mnemonicIndex.help"));
        this.miHelp.setActionCommand("cmd.help");
        this.miHelp.addActionListener(this.jftp);
        this.menuExecute.add(this.miHelp);
        this.miStat = new MMenuItem(resources.getString("text.stat"));
        this.miStat.setMnemonic(resources.getString("mnemonic.stat"), resources.getString("mnemonicIndex.stat"));
        this.miStat.setActionCommand("cmd.stat");
        this.miStat.addActionListener(this.jftp);
        this.menuExecute.add(this.miStat);
        this.miSyst = new MMenuItem(resources.getString("text.syst"));
        this.miSyst.setMnemonic(resources.getString("mnemonic.syst"), resources.getString("mnemonicIndex.syst"));
        this.miSyst.setActionCommand("cmd.syst");
        this.miSyst.addActionListener(this.jftp);
        this.menuExecute.add(this.miSyst);
        this.miNoop = new MMenuItem(resources.getString("text.noop"));
        this.miNoop.setMnemonic(resources.getString("mnemonic.noop"), resources.getString("mnemonicIndex.noop"));
        this.miNoop.setActionCommand("cmd.noop");
        this.miNoop.addActionListener(this.jftp);
        this.menuExecute.add(this.miNoop);
        this.miOther = new MMenuItem(resources.getString("text.other"));
        this.miOther.setMnemonic(resources.getString("mnemonic.other"), resources.getString("mnemonicIndex.other"));
        this.miOther.setActionCommand("cmd.other");
        this.miOther.addActionListener(this.jftp);
        this.menuExecute.add(this.miOther);
        this.addSeparator();
        this.miApplyFilter = new MMenuItem(resources.getString("text.applyFilter"));
        this.miApplyFilter.setMnemonic(resources.getString("mnemonic.applyFilter"), resources.getString("mnemonicIndex.applyFilter"));
        this.miApplyFilter.setActionCommand("cmd.applyRemoteFileFilter");
        this.miApplyFilter.addActionListener(this.jftp);
        this.add(this.miApplyFilter);
        this.miClearFilter = new MMenuItem(resources.getString("text.clearFilter"));
        this.miClearFilter.setMnemonic(resources.getString("mnemonic.clearFilter"), resources.getString("mnemonicIndex.clearFilter"));
        this.miApplyFilter.setActionCommand("cmd.applyRemoteFileFilter");
        this.miClearFilter.setActionCommand("cmd.clearRemoteFileFilter");
        this.miClearFilter.addActionListener(this.jftp);
        this.add(this.miClearFilter);
        this.addSeparator();
        this.miRefresh = new MMenuItem(resources.getString("text.refresh"));
        this.miRefresh.setMnemonic(resources.getString("mnemonic.refresh"), resources.getString("mnemonicIndex.refresh"));
        this.miRefresh.setAccelerator(KeyStroke.getKeyStroke(116, GUIUtil.ACCELERATOR_MASK));
        this.miRefresh.setActionCommand("cmd.refreshRemotePane");
        this.miRefresh.addActionListener(this.jftp);
        this.add(this.miRefresh);
        this.addSeparator();
        this.miProperties = new MMenuItem(resources.getString("text.properties"));
        this.miProperties.setMnemonic(resources.getString("mnemonic.properties"), resources.getString("mnemonicIndex.properties"));
        this.miProperties.setAccelerator(KeyStroke.getKeyStroke(73, GUIUtil.ACCELERATOR_MASK));
        this.miProperties.setActionCommand("cmd.remoteFileProperties");
        this.miProperties.addActionListener(this.jftp);
        this.add(this.miProperties);
        this.addSeparator();
        this.miSelectAll = new MMenuItem();
        this.miSelectAll.setText(resources.getString("text.selectAll"));
        this.miSelectAll.setMnemonic(resources.getString("mnemonic.selectAll"), resources.getString("mnemonicIndex.selectAll"));
        this.miSelectAll.setActionCommand("cmd.remoteSelectAll");
        this.miSelectAll.addActionListener(this.jftp);
        this.add(this.miSelectAll);
        this.miInvertSelection = new MMenuItem();
        this.miInvertSelection.setText(resources.getString("text.invertSelection"));
        this.miInvertSelection.setMnemonic(resources.getString("mnemonic.invertSelection"), resources.getString("mnemonicIndex.invertSelection"));
        this.miInvertSelection.setActionCommand("cmd.remoteInvertSelection");
        this.miInvertSelection.addActionListener(this.jftp);
        this.add(this.miInvertSelection);
    }

    public void menuCanceled(MenuEvent menuEvent) {
        this.miOpenFile.setEnabled(true);
        this.miEditFile.setEnabled(true);
        this.miPrintFile.setEnabled(true);
        this.menuNew.setEnabled(true);
        this.miChangeDirectory.setEnabled(true);
        this.miRename.setEnabled(true);
        this.miDelete.setEnabled(true);
        this.menuExecute.setEnabled(true);
        this.miApplyFilter.setEnabled(true);
        this.miClearFilter.setEnabled(true);
        this.miRefresh.setEnabled(true);
        this.miProperties.setEnabled(true);
        this.miSelectAll.setEnabled(true);
        this.miInvertSelection.setEnabled(true);
    }

    public void menuDeselected(MenuEvent menuEvent) {
        this.miOpenFile.setEnabled(true);
        this.miEditFile.setEnabled(true);
        this.miPrintFile.setEnabled(true);
        this.menuNew.setEnabled(true);
        this.miChangeDirectory.setEnabled(true);
        this.miRename.setEnabled(true);
        this.miDelete.setEnabled(true);
        this.menuExecute.setEnabled(true);
        this.miApplyFilter.setEnabled(true);
        this.miClearFilter.setEnabled(true);
        this.miRefresh.setEnabled(true);
        this.miProperties.setEnabled(true);
        this.miSelectAll.setEnabled(true);
        this.miInvertSelection.setEnabled(true);
    }

    public void menuSelected(MenuEvent menuEvent) {
        FTPSession session = this.jftp.getCurrentSession();
        boolean nullSession = session == null;
        boolean connected = !nullSession && session.isConnected();
        int selectionCount = 0;
        if (connected) {
            selectionCount = session.getRemoteFileSelectionCount();
        }
        boolean isFile = false;
        RemoteFile selectedFile = null;
        if (selectionCount == 1) {
            selectedFile = session.getSelectedRemoteFile();
            isFile = selectedFile.isFile();
        }
        this.miOpenFile.setEnabled(connected && selectionCount == 1);
        this.miEditFile.setEnabled(connected && selectionCount == 1 && isFile);
        this.miPrintFile.setEnabled(connected && selectionCount == 1 && isFile);
        this.menuNew.setEnabled(connected);
        this.miChangeDirectory.setEnabled(connected);
        this.miRename.setEnabled(connected && selectionCount == 1);
        this.miDelete.setEnabled(connected && selectionCount > 0);
        this.menuExecute.setEnabled(connected);
        this.miApplyFilter.setEnabled(connected);
        this.miClearFilter.setEnabled(connected && session.getRemoteFileFilter() != null);
        this.miRefresh.setEnabled(connected);
        this.miProperties.setEnabled(connected && selectionCount == 1);
        this.miSelectAll.setEnabled(connected);
        this.miInvertSelection.setEnabled(connected);
    }

    private boolean isZipFile(RemoteFile file) {
        String ext = file.getExtension();
        return "ZIP".equalsIgnoreCase(ext);
    }
}

