/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Box;

public class RenameLocalFileDlg
extends MDialog
implements ActionListener {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.RenameLocalFileDlg");
    private static final String HELP_ID = "local.rename";
    private MTextField tfFrom = null;
    private MTextField tfTo = null;
    private MButton butRename = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private String fromFile = null;
    private boolean approved = false;

    public RenameLocalFileDlg(Frame parent, String fromFile) {
        super(parent, resources.getString("title.dialog"), true);
        this.fromFile = fromFile;
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public void windowOpened(WindowEvent evt) {
        if (this.tfFrom.getText().trim().length() > 0) {
            this.tfTo.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butRename) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.close();
        } else if (evt.getSource() == this.butCancel) {
            this.close();
        }
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private void close() {
        this.setVisible(false);
    }

    public String getFromFile() {
        if (this.approved) {
            return this.tfFrom.getText();
        }
        return null;
    }

    public String getToFile() {
        if (this.approved) {
            return this.tfTo.getText();
        }
        return null;
    }

    private boolean validateInput() {
        String message = null;
        MTextField errorComponent = null;
        if (this.tfFrom.getText().trim().length() == 0) {
            message = resources.getString("error.from.required");
            errorComponent = this.tfFrom;
        } else if (this.tfTo.getText().trim().length() == 0) {
            message = resources.getString("error.to.required");
            errorComponent = this.tfTo;
        }
        if (message == null) {
            return true;
        }
        GUIUtil.showError((Component)this, message);
        if (errorComponent != null) {
            ((Component)errorComponent).requestFocusInWindow();
        }
        return false;
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        MLabel labFrom = new MLabel(resources.getString("text.from"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add((Component)labFrom, c);
        this.tfFrom = new MTextField(20);
        this.tfFrom.setText(this.fromFile);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(12, 0, 11, 11);
        this.getContentPane().add((Component)this.tfFrom, c);
        MLabel labTo = new MLabel(resources.getString("text.to"));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)labTo, c);
        this.tfTo = new MTextField(20);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(0, 0, 11, 11);
        this.getContentPane().add((Component)this.tfTo, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 0.5;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(6, 12, 11, 11);
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butRename = new MButton(resources.getString("text.rename"));
        this.butRename.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butRename);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butRename);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

