/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MCheckBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MRadioButton;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class SecurityPrefsPanel
extends JPanel
implements ActionListener,
ItemListener {
    private MCheckBox cbDataChannelEncryption;
    private MRadioButton radioImplicitSSL;
    private MRadioButton radioExplicitSSL;
    private MRadioButton radioUseSSLIfAvailable;
    private MRadioButton radioNoSSL;
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.SecurityPrefsPanel");

    public SecurityPrefsPanel() {
        this.initComponents();
        this.populateScreen();
    }

    public void actionPerformed(ActionEvent evt) {
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.radioNoSSL) {
            this.cbDataChannelEncryption.setEnabled(!this.radioNoSSL.isSelected());
        } else if (evt.getSource() == this.radioImplicitSSL) {
            // empty if block
        }
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void populateScreen(JFTPPreferences prefs) {
        int sslUsage = prefs.getSSLUsage();
        switch (sslUsage) {
            case 0: {
                this.radioNoSSL.setSelected(true);
                break;
            }
            case 1: {
                this.radioUseSSLIfAvailable.setSelected(true);
                break;
            }
            case 3: {
                this.radioExplicitSSL.setSelected(true);
                break;
            }
            case 2: {
                this.radioImplicitSSL.setSelected(true);
            }
        }
        this.cbDataChannelEncryption.setSelected(prefs.isDataChannelUnencrypted());
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        this.radioNoSSL = new MRadioButton(resources.getString("text.noSSL"));
        this.radioUseSSLIfAvailable = new MRadioButton(resources.getString("text.useSSLIfAvailable"));
        this.radioExplicitSSL = new MRadioButton(resources.getString("text.explicitSSL"));
        this.radioImplicitSSL = new MRadioButton(resources.getString("text.implicitSSL"));
        this.cbDataChannelEncryption = new MCheckBox(resources.getString("text.dataChannelEncryption"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioNoSSL);
        bg.add(this.radioUseSSLIfAvailable);
        bg.add(this.radioExplicitSSL);
        bg.add(this.radioImplicitSSL);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.radioNoSSL, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.radioUseSSLIfAvailable, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.radioExplicitSSL, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.radioImplicitSSL, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.cbDataChannelEncryption, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new MLabel(), c);
        this.radioNoSSL.addItemListener(this);
        this.radioImplicitSSL.addItemListener(this);
        this.radioNoSSL.setSelected(true);
    }

    public boolean validateFields() {
        return true;
    }

    public void saveChanges() {
        int sslUsage = 0;
        if (this.radioUseSSLIfAvailable.isSelected()) {
            sslUsage = 1;
        } else if (this.radioExplicitSSL.isSelected()) {
            sslUsage = 3;
        } else if (this.radioImplicitSSL.isSelected()) {
            sslUsage = 2;
        }
        JFTP.prefs.setSSLUsage(sslUsage);
        JFTP.prefs.setDataChannelUnencrypted(this.cbDataChannelEncryption.isSelected());
    }
}

