/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTPUtil;
import com.myjavaworld.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends JPanel {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.StatusBar");
    private MLabel labStatus = null;
    private JProgressBar progressBar = null;
    private MLabel labSpeed = null;
    private MLabel labElapsedTime = null;
    private MLabel labSecured = null;
    private MessageFormat speedFormat;
    private MessageFormat elapsedTimeFormat;

    public StatusBar() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.speedFormat = new MessageFormat(resources.getString("value.speed"));
        this.elapsedTimeFormat = new MessageFormat(resources.getString("value.elapsedTime"));
        this.initComponents();
    }

    public void setStatus(String status) {
        this.labStatus.setText(status);
    }

    public void setMinimum(int min) {
        this.progressBar.setMinimum(min);
    }

    public void setMaximum(int max) {
        this.progressBar.setMaximum(max);
    }

    public void setProgress(int value) {
        this.progressBar.setValue(value);
    }

    public void setSpeed(long speed) {
        Object[] args = new Object[]{new Long(speed)};
        this.labSpeed.setText(this.speedFormat.format(args));
    }

    public void setTimeElapsed(String timeElapsed) {
        Object[] args = new Object[]{timeElapsed};
        this.labElapsedTime.setText(this.elapsedTimeFormat.format(args));
    }

    public void setSecured(boolean secured) {
        this.labSecured.setIcon(secured ? JFTPUtil.getIcon("lock16.gif") : null);
        this.labSecured.setText(secured ? "" : "  ");
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setStringPainted(!indeterminate);
    }

    public void reset() {
        this.labStatus.setText("");
        this.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        this.labSpeed.setText("");
        this.labElapsedTime.setText("");
    }

    private void initComponents() {
        this.labStatus = new MLabel();
        this.progressBar = new JProgressBar(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setBorder(BorderFactory.createBevelBorder(1));
        this.labSpeed = new MLabel("", 4);
        this.labSpeed.setBorder(BorderFactory.createBevelBorder(1));
        this.labElapsedTime = new MLabel("");
        this.labElapsedTime.setBorder(BorderFactory.createBevelBorder(1));
        this.labSecured = new MLabel("  ");
        this.labSecured.setBorder(BorderFactory.createBevelBorder(1));
        JPanel subPanel = new JPanel(new GridLayout(1, 4, 5, 0));
        subPanel.add(this.labStatus);
        subPanel.add(this.progressBar);
        subPanel.add(this.labElapsedTime);
        subPanel.add(this.labSpeed);
        this.add((Component)subPanel, "Center");
        this.add((Component)this.labSecured, "East");
    }
}

