/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.util.ResourceLoader;
import java.awt.Color;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class StatusWindow
extends JTextPane {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.StatusWindow");
    public static final int MAX_SIZE = 16384;
    private Document document = null;
    private Style normalStyle = null;
    private Style commandStyle = null;
    private Style replyStyle = null;
    private Style errorStyle = null;
    private Style statusStyle = null;
    private Style infoStyle = null;

    public StatusWindow() {
        this.setMargin(new Insets(6, 6, 6, 6));
        this.document = this.getDocument();
        this.setEditable(false);
        this.initStyles();
        MessageFormat format = new MessageFormat(resources.getString("text.productInfo"));
        Object[] args = new Object[]{"JFTP", "5.0.1", "20120623"};
        this.addInfo(format.format(args));
    }

    public void addNormal(String str) {
        this.append(str, this.normalStyle);
    }

    public void addCommand(String str) {
        this.append(str, this.commandStyle);
    }

    public void addReply(String str) {
        this.append(str, this.replyStyle);
    }

    public void addError(String str) {
        this.append(str, this.errorStyle);
    }

    public void addStatus(String str) {
        this.append(str, this.statusStyle);
    }

    public void addInfo(String str) {
        this.append(str, this.infoStyle);
    }

    private synchronized void append(String str, Style style) {
        try {
            if (this.document.getLength() >= 16384) {
                this.document.remove(0, this.document.getLength());
            }
            this.document.insertString(this.document.getLength(), str, style);
            this.document.insertString(this.document.getLength(), "\n", style);
            this.setCaretPosition(this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void initStyles() {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        this.normalStyle = this.addStyle("normalStyle", def);
        StyleConstants.setFontFamily(def, "Dailog");
        this.commandStyle = this.addStyle("commandStyle", this.normalStyle);
        StyleConstants.setForeground(this.commandStyle, new Color(0, 0, 255));
        this.replyStyle = this.addStyle("replyStyle", this.normalStyle);
        StyleConstants.setForeground(this.replyStyle, new Color(0, 102, 51));
        this.errorStyle = this.addStyle("errorStyle", this.normalStyle);
        StyleConstants.setForeground(this.errorStyle, new Color(255, 0, 0));
        this.statusStyle = this.addStyle("statusStyle", this.normalStyle);
        StyleConstants.setForeground(this.statusStyle, new Color(255, 128, 0));
        this.infoStyle = this.addStyle("infoStyle", this.normalStyle);
    }
}

