/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MMenu;
import com.myjavaworld.gui.MMenuItem;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.actions.ManageCertificatesAction;
import com.myjavaworld.jftp.actions.ManageFavoritesAction;
import com.myjavaworld.util.ResourceLoader;
import com.myjavaworld.util.SystemUtil;
import java.util.ResourceBundle;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ToolsMenu
extends MMenu
implements MenuListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ToolsMenu");
    private JFTP jftp = null;
    private MMenuItem miAddToFavorites = null;
    private MMenuItem miManageFavorites = null;
    private MMenuItem miManageCertificates = null;
    private MMenuItem miPreferences = null;

    public ToolsMenu(JFTP jftp) {
        this.jftp = jftp;
        this.setText(resources.getString("text.tools"));
        this.setMnemonic(resources.getString("mnemonic.tools"), resources.getString("mnemonicIndex.tools"));
        this.prepareMenuItems();
        this.addMenuListener(this);
    }

    private void prepareMenuItems() {
        this.miAddToFavorites = new MMenuItem();
        this.miAddToFavorites.setText(resources.getString("text.addToFavorites"));
        this.miAddToFavorites.setActionCommand("cmd.addToFavorites");
        this.miAddToFavorites.addActionListener(this.jftp);
        this.miAddToFavorites.setMnemonic(resources.getString("mnemonic.addToFavorites"), resources.getString("mnemonicIndex.addToFavorites"));
        this.add(this.miAddToFavorites);
        this.miManageFavorites = new MMenuItem();
        this.miManageFavorites.setText(resources.getString("text.manageFavorites"));
        this.miManageFavorites.addActionListener(ManageFavoritesAction.getInstance(this.jftp));
        this.miManageFavorites.setMnemonic(resources.getString("mnemonic.manageFavorites"), resources.getString("mnemonicIndex.manageFavorites"));
        this.add(this.miManageFavorites);
        this.addSeparator();
        this.miManageCertificates = new MMenuItem();
        this.miManageCertificates.setText(resources.getString("text.manageCertificates"));
        this.miManageCertificates.addActionListener(ManageCertificatesAction.getInstance(this.jftp));
        this.miManageCertificates.setMnemonic(resources.getString("mnemonic.manageCertificates"), resources.getString("mnemonicIndex.manageCertificates"));
        this.add(this.miManageCertificates);
        this.miPreferences = new MMenuItem(resources.getString("text.preferences"));
        this.miPreferences.setActionCommand("cmd.preferences");
        this.miPreferences.setMnemonic(resources.getString("mnemonic.preferences"), resources.getString("mnemonicIndex.preferences"));
        this.miPreferences.addActionListener(this.jftp);
        if (!SystemUtil.isMac()) {
            this.addSeparator();
            this.add(this.miPreferences);
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        FTPSession currentSession = this.jftp.getCurrentSession();
        this.getMenuComponent(0).setEnabled(currentSession != null && currentSession.isConnected());
    }
}

