/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MMenu;
import com.myjavaworld.gui.MRadioButtonMenuItem;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.util.ResourceLoader;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class TransferModeMenu
extends MMenu
implements MenuListener {
    private JFTP jftp = null;
    private MRadioButtonMenuItem miAutoDetect = null;
    private MRadioButtonMenuItem miAscii = null;
    private MRadioButtonMenuItem miBinary = null;

    public TransferModeMenu(JFTP jftp) {
        this.jftp = jftp;
        ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.TransferModeMenu");
        this.setText(resources.getString("text.transferMode"));
        this.setMnemonic(resources.getString("mnemonic.transferMode"), resources.getString("mnemonicIndex.transferMode"));
        this.prepareMenuItems(resources);
        this.addMenuListener(this);
    }

    private void prepareMenuItems(ResourceBundle resources) {
        this.miAutoDetect = new MRadioButtonMenuItem(resources.getString("text.autoDetect"));
        this.miAutoDetect.setMnemonic(resources.getString("mnemonic.autoDetect"), resources.getString("mnemonicIndex.autoDetect"));
        this.miAutoDetect.setAccelerator(KeyStroke.getKeyStroke(48, GUIUtil.ACCELERATOR_MASK));
        this.miAutoDetect.setActionCommand("cmd.transferType.autoDetect");
        this.miAutoDetect.addActionListener(this.jftp);
        this.add(this.miAutoDetect);
        this.miAscii = new MRadioButtonMenuItem(resources.getString("text.ascii"));
        this.miAscii.setMnemonic(resources.getString("mnemonic.ascii"), resources.getString("mnemonicIndex.ascii"));
        this.miAscii.setActionCommand("cmd.transferType.ascii");
        this.miAscii.setAccelerator(KeyStroke.getKeyStroke(49, GUIUtil.ACCELERATOR_MASK));
        this.miAscii.addActionListener(this.jftp);
        this.add(this.miAscii);
        this.miBinary = new MRadioButtonMenuItem(resources.getString("text.binary"));
        this.miBinary.setMnemonic(resources.getString("mnemonic.binary"), resources.getString("mnemonicIndex.binary"));
        this.miBinary.setActionCommand("cmd.transferType.binary");
        this.miBinary.setAccelerator(KeyStroke.getKeyStroke(50, GUIUtil.ACCELERATOR_MASK));
        this.miBinary.addActionListener(this.jftp);
        this.add(this.miBinary);
        ButtonGroup bgTransferType = new ButtonGroup();
        bgTransferType.add(this.miAutoDetect);
        bgTransferType.add(this.miAscii);
        bgTransferType.add(this.miBinary);
        this.miAutoDetect.setSelected(true);
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        FTPSession session = this.jftp.getCurrentSession();
        boolean enable = true;
        if (session == null) {
            enable = false;
        }
        this.getMenuComponent(0).setEnabled(enable);
        this.getMenuComponent(1).setEnabled(enable);
        this.getMenuComponent(2).setEnabled(enable);
        if (session != null) {
            boolean autoDetect = session.isAutoDetect();
            if (autoDetect) {
                this.miAutoDetect.setSelected(true);
            } else {
                int transferType = session.getTransferType();
                if (transferType == 1) {
                    this.miAscii.setSelected(true);
                } else if (transferType == 2) {
                    this.miBinary.setSelected(true);
                }
            }
        }
    }
}

