/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTable;
import com.myjavaworld.gui.MTableCellRenderer;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TransferModesPrefsPanel
extends JPanel {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.TransferModesPrefsPanel");
    private static final String[] COLUMN_NAMES = new String[]{resources.getString("text.fileType"), resources.getString("text.transferMode")};
    private static final String[] TYPE_NAMES = new String[]{"ASCII", "Binary"};
    private TypesTableModel model = null;
    private MTable table = null;
    private MComboBox comboDefaultTransferMode = null;

    public TransferModesPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
        this.configureTable();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    public boolean validateFields() {
        return true;
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void populateScreen(JFTPPreferences prefs) {
        this.comboDefaultTransferMode.setSelectedIndex(prefs.getDefaultTransferType() - 1);
        this.model.setData(prefs.getTransferTypes());
    }

    public void saveChanges() {
        int rowCount = this.model.getRowCount();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (int i = 0; i < rowCount; ++i) {
            String extension = (String)this.model.getValueAt(i, 0);
            if (extension.trim().length() <= 0) continue;
            map.put(extension, this.model.getValueAt(i, 1));
        }
        JFTP.prefs.setTransferTypes(map);
        JFTP.prefs.setDefaultTransferType(this.comboDefaultTransferMode.getSelectedIndex() + 1);
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.model = new TypesTableModel();
        this.table = new MTable(this.model);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        c.insets = new Insets(12, 12, 12, 12);
        MScrollPane scroller = new MScrollPane(this.table);
        this.add((Component)scroller, c);
        MLabel labDefaultTransferMode = new MLabel(resources.getString("text.defaultTransferMode"));
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)labDefaultTransferMode, c);
        this.comboDefaultTransferMode = new MComboBox(TYPE_NAMES);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.comboDefaultTransferMode, c);
        this.populateScreen();
    }

    private void configureTable() {
        this.table.setDefaultRenderer(Object.class, new MTableCellRenderer());
        this.table.setDefaultRenderer(Integer.class, new TransferTypeCellRenderer());
        MComboBox comboTypes = new MComboBox(TYPE_NAMES);
        this.table.setDefaultEditor(Integer.class, new DefaultCellEditor(comboTypes));
        DefaultCellEditor fileTypeEditor = new DefaultCellEditor(new MTextField());
        fileTypeEditor.setClickCountToStart(1);
        this.table.setDefaultEditor(Object.class, fileTypeEditor);
    }

    private static class TransferTypeCellRenderer
    extends MTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            int type = (Integer)value;
            this.setText(TYPE_NAMES[type - 1]);
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setFont(table.getFont());
            return this;
        }
    }

    private class TypesTableModel
    extends AbstractTableModel {
        private Vector extensions = null;
        private Vector types = null;

        public TypesTableModel() {
            this(new TreeMap());
        }

        public TypesTableModel(Map map) {
            this.setData(map);
        }

        public void setData(Map map) {
            if (map == null) {
                map = new TreeMap();
            }
            this.extensions = new Vector(map.size());
            this.types = new Vector(map.size());
            for (String key : map.keySet()) {
                this.extensions.add(key);
                this.types.add(map.get(key));
            }
            this.addEmptyRow();
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.extensions.size();
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.extensions.get(row);
            }
            return this.types.get(row);
        }

        public void setValueAt(Object value, int row, int col) {
            String str = value.toString();
            if (col == 0) {
                this.extensions.set(row, str.toUpperCase());
                if (row == this.extensions.size() - 1 && str.trim().length() != 0) {
                    this.addEmptyRow();
                }
            } else {
                int type = str.equals(TYPE_NAMES[0]) ? 1 : 2;
                this.types.set(row, new Integer(type));
            }
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int col) {
            if (col == 1) {
                return Integer.class;
            }
            return Object.class;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        private void addEmptyRow() {
            this.extensions.add("");
            this.types.add(new Integer(1));
        }
    }
}

