/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.MComboBox;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPPreferences;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class UIPrefsPanel
extends JPanel {
    private static final ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.UIPrefsPanel");
    private MComboBox comboLookAndFeels = null;

    public UIPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        MLabel labLookAndFeel = new MLabel(resources.getString("text.lookAndFeel"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        this.add((Component)labLookAndFeel, c);
        this.comboLookAndFeels = new MComboBox(this.getInstalledLookAndFeels());
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.comboLookAndFeels, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new MLabel(), c);
        this.populateScreen();
    }

    public boolean validateFields() {
        return true;
    }

    public void populateScreen() {
        this.populateScreen(JFTP.prefs);
    }

    public void populateScreen(JFTPPreferences prefs) {
        this.comboLookAndFeels.setSelectedItem(this.getLookAndFeelName(prefs.getLookAndFeelClassName()));
    }

    public void saveChanges() {
        String selecteLookAndFeel = (String)this.comboLookAndFeels.getSelectedItem();
        JFTP.prefs.setLookAndFeelClassName(this.getLookAndFeelClassName(selecteLookAndFeel));
    }

    private String[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        String[] lnfNames = new String[lnfs.length];
        for (int i = 0; i < lnfs.length; ++i) {
            lnfNames[i] = lnfs[i].getName();
        }
        return lnfNames;
    }

    private String getLookAndFeelClassName(String lookAndFeelName) {
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lnfs.length; ++i) {
            if (!lookAndFeelName.equals(lnfs[i].getName())) continue;
            return lnfs[i].getClassName();
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    private String getLookAndFeelName(String lookAndFeelClassName) {
        if (lookAndFeelClassName == null) {
            return null;
        }
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lnfs.length; ++i) {
            if (!lookAndFeelClassName.equals(lnfs[i].getClassName())) continue;
            return lnfs[i].getName();
        }
        return null;
    }
}

