/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.gui.MRadioButton;
import com.myjavaworld.gui.MTextField;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ZipAndUploadDlg
extends MDialog
implements ActionListener,
ItemListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ZipAndUploadDlg");
    private static final String HELP_ID = "transfer.zipAndUpload";
    private MTextField tfFileName = null;
    private MRadioButton radioTempDir = null;
    private MRadioButton radioCurrentDir = null;
    private MRadioButton radioOtherDir = null;
    private MTextField tfOtherDir = null;
    private MButton butBrowse = null;
    private MButton butUpload = null;
    private MButton butCancel = null;
    private MButton butHelp = null;
    private boolean approved = false;
    private JFTP jftp = null;

    public ZipAndUploadDlg(JFTP jftp) {
        super(jftp);
        this.jftp = jftp;
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.setResizable(false);
        this.initComponents();
        this.pack();
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String getFileName() {
        if (this.approved) {
            return this.tfFileName.getText();
        }
        return null;
    }

    public boolean getDeleteOption() {
        return this.radioTempDir.isSelected();
    }

    public File getZipFile() {
        File zipFile = null;
        if (this.approved) {
            if (this.radioTempDir.isSelected()) {
                try {
                    zipFile = File.createTempFile("jftp", ".zip");
                }
                catch (Exception exp) {
                    GUIUtil.showError((Component)this, exp);
                }
            } else if (this.radioCurrentDir.isSelected()) {
                zipFile = new File(this.jftp.getCurrentSession().getLocalWorkingDirectory().getFile(), this.tfFileName.getText().trim());
            } else if (this.radioOtherDir.isSelected()) {
                zipFile = new File(this.tfOtherDir.getText().trim(), this.tfFileName.getText().trim());
            }
        }
        return zipFile;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.butUpload) {
            if (!this.validateInput()) {
                return;
            }
            this.approved = true;
            this.setVisible(false);
        } else if (source == this.butCancel) {
            this.setVisible(false);
        } else if (source == this.radioOtherDir) {
            if (this.tfOtherDir.getText().trim().length() == 0) {
                this.browse();
            }
        } else if (source == this.butBrowse) {
            this.browse();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        boolean enable = this.radioOtherDir.isSelected();
        this.tfOtherDir.setEnabled(enable);
        this.butBrowse.setEnabled(enable);
    }

    protected void escape() {
        this.butCancel.doClick();
    }

    private boolean validateInput() {
        String error = null;
        MTextField errorComponent = null;
        if (this.tfFileName.getText().trim().length() < 1) {
            error = resources.getString("error.fileName.required");
            errorComponent = this.tfFileName;
        } else if (this.radioOtherDir.isSelected()) {
            if (this.tfOtherDir.getText().trim().length() == 0) {
                error = resources.getString("error.otherDir.required");
                errorComponent = this.tfOtherDir;
            } else {
                File dir = new File(this.tfOtherDir.getText().trim());
                if (!dir.exists() || !dir.isDirectory()) {
                    error = resources.getString("error.otherDir.doesNotExists");
                    errorComponent = this.tfOtherDir;
                }
            }
        }
        if (error != null) {
            GUIUtil.showError((Component)this, error);
            if (errorComponent != null) {
                ((Component)errorComponent).requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    private void browse() {
        File selectedDir;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(CommonResources.getString("title.selectDirectory"));
        chooser.setApproveButtonText(CommonResources.getString("text.select"));
        int option = chooser.showOpenDialog(this);
        if (option == 0 && (selectedDir = chooser.getSelectedFile()) != null) {
            this.tfOtherDir.setText(selectedDir.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        MLabel labFileName = new MLabel(resources.getString("text.fileName"));
        this.tfFileName = new MTextField(30);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add((Component)labFileName, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 12);
        this.getContentPane().add((Component)this.tfFileName, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add(this.getOptionsPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(6, 12, 12, 12);
        c.anchor = 14;
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.options")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.radioTempDir = new MRadioButton(resources.getString("text.zipToTempDir"), true);
        this.radioCurrentDir = new MRadioButton(resources.getString("text.zipToCurrentDir"), false);
        this.radioOtherDir = new MRadioButton(resources.getString("text.zipToOtherDir"), false);
        this.tfOtherDir = new MTextField(30);
        this.tfOtherDir.setEnabled(false);
        this.butBrowse = new MButton(CommonResources.getString("text.browse"));
        this.butBrowse.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioTempDir);
        bg.add(this.radioCurrentDir);
        bg.add(this.radioOtherDir);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.radioTempDir, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.radioCurrentDir, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.radioOtherDir, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.tfOtherDir, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.butBrowse, c);
        this.radioOtherDir.addActionListener(this);
        this.radioOtherDir.addItemListener(this);
        this.butBrowse.addActionListener(this);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butUpload = new MButton(resources.getString("text.upload"));
        this.butUpload.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butUpload);
        this.butCancel = new MButton(CommonResources.getString("text.cancel"));
        this.butCancel.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butUpload);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butCancel);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

