/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.actions;

import com.myjavaworld.jftp.ConnectionDlg;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.RemoteHost;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ConnectAction
implements ActionListener {
    private JFTP jftp = null;
    private static ConnectAction instance = null;

    private ConnectAction(JFTP jftp) {
        this.jftp = jftp;
    }

    public static synchronized ConnectAction getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new ConnectAction(jftp);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent evt) {
        FTPSession session = this.jftp.getCurrentSession();
        if (session == null) {
            return;
        }
        ConnectionDlg connectionDlg = new ConnectionDlg(this.jftp);
        RemoteHost host = session.getRemoteHost();
        if (host == null) {
            host = new RemoteHost();
            host.setFTPClientClassName(JFTP.prefs.getClient());
            host.setListParserClassName(JFTP.prefs.getListParser());
            host.setPassive(JFTP.prefs.isPassive());
            host.setSSLUsage(JFTP.prefs.getSSLUsage());
            host.setDataChannelUnencrypted(JFTP.prefs.isDataChannelUnencrypted());
        }
        connectionDlg.setRemoteHost(host);
        connectionDlg.setLocationRelativeTo(this.jftp);
        connectionDlg.setVisible(true);
        RemoteHost remoteHost = connectionDlg.getRemoteHost();
        connectionDlg.dispose();
        if (remoteHost != null) {
            session.connect(remoteHost);
        }
    }
}

