/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.actions;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.DownloadAndUnzipDlg;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.zip.Unzip;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class DownloadAndUnzipAction
implements ActionListener {
    private JFTP jftp = null;
    private static DownloadAndUnzipAction instance = null;

    private DownloadAndUnzipAction(JFTP jftp) {
        this.jftp = jftp;
    }

    public static synchronized DownloadAndUnzipAction getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new DownloadAndUnzipAction(jftp);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent evt) {
        this.downloadAndUnzip();
    }

    private void downloadAndUnzip() {
        final FTPSession session = this.jftp.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        final RemoteFile selectedFile = session.getSelectedRemoteFile();
        if (selectedFile == null) {
            return;
        }
        if (!"ZIP".equalsIgnoreCase(selectedFile.getExtension())) {
            return;
        }
        DownloadAndUnzipDlg dlg = new DownloadAndUnzipDlg(this.jftp, selectedFile);
        dlg.setLocationRelativeTo(this.jftp);
        dlg.setVisible(true);
        if (!dlg.isApproved()) {
            return;
        }
        final File localFile = dlg.getDownloadTo();
        final File unzipTo = dlg.getUnzipDirectory();
        final boolean deleteOption = dlg.getDeleteOption();
        dlg.dispose();
        System.gc();
        session.clearAbortFlag();
        session.setBusy(true);
        new SwingWorker(){
            private Throwable error = null;

            public Object construct() {
                session.downloadDataFile(selectedFile, localFile);
                try {
                    Unzip unzip = new Unzip(localFile);
                    unzip.setTargetDirectory(unzipTo);
                    unzip.addZipListener(session);
                    unzip.addProgressListener(session);
                    unzip.open();
                    unzip.unzip();
                    unzip.close();
                    if (deleteOption) {
                        localFile.delete();
                    }
                }
                catch (Throwable t) {
                    this.error = t;
                }
                return null;
            }

            public void finished() {
                session.setBusy(false);
                session.resetStatusBar();
                if (this.error != null) {
                    GUIUtil.showError((Component)DownloadAndUnzipAction.this.jftp, this.error);
                }
                session.refreshLocalPane();
            }
        }.start();
    }
}

