/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.actions;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.DownloadAsDlg;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DownloadAsAction
implements ActionListener {
    private JFTP jftp = null;
    private static DownloadAsAction instance = null;

    private DownloadAsAction(JFTP jftp) {
        this.jftp = jftp;
    }

    public static synchronized DownloadAsAction getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new DownloadAsAction(jftp);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent evt) {
        final FTPSession session = this.jftp.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        final RemoteFile selectedFile = session.getSelectedRemoteFile();
        if (selectedFile == null) {
            return;
        }
        DownloadAsDlg dlg = new DownloadAsDlg(this.jftp, selectedFile);
        dlg.setLocationRelativeTo(this.jftp);
        dlg.setVisible(true);
        if (!dlg.isApproved()) {
            return;
        }
        final String fileName = dlg.getFileName();
        dlg.dispose();
        System.gc();
        session.clearAbortFlag();
        session.setBusy(true);
        new SwingWorker(){

            public Object construct() {
                session.download(session.getRemoteWorkingDirectory(), session.getLocalWorkingDirectory().getFile(), selectedFile, fileName);
                return null;
            }

            public void finished() {
                session.setBusy(false);
                session.refreshLocalPane();
            }
        }.start();
    }
}

