/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.actions;

import com.myjavaworld.ftp.RemoteFile;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class OpenRemoteFileAction
implements ActionListener {
    private JFTP jftp = null;
    private static OpenRemoteFileAction instance = null;

    private OpenRemoteFileAction(JFTP jftp) {
        this.jftp = jftp;
    }

    public static synchronized OpenRemoteFileAction getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new OpenRemoteFileAction(jftp);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent evt) {
        final FTPSession session = this.jftp.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        final RemoteFile selectedFile = session.getSelectedRemoteFile();
        if (selectedFile == null) {
            return;
        }
        if (selectedFile.isDirectory()) {
            session.setRemoteWorkingDirectory(selectedFile);
            return;
        }
        session.clearAbortFlag();
        session.setBusy(true);
        new SwingWorker(){
            private File tempFile = null;

            public Object construct() {
                this.tempFile = session.downloadToTempFile(selectedFile, true);
                return null;
            }

            public void finished() {
                session.setBusy(false);
                if (this.tempFile == null) {
                    return;
                }
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().open(this.tempFile);
                    }
                }
                catch (Throwable t) {
                    GUIUtil.showError((Component)OpenRemoteFileAction.this.jftp, t);
                }
            }
        }.start();
    }
}

