/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.actions;

import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.UploadAsDlg;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class UploadAsAction
implements ActionListener {
    private JFTP jftp = null;
    private static UploadAsAction instance = null;

    private UploadAsAction(JFTP jftp) {
        this.jftp = jftp;
    }

    public static synchronized UploadAsAction getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new UploadAsAction(jftp);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent evt) {
        final FTPSession session = this.jftp.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        final LocalFile selectedFile = session.getSelectedLocalFile();
        if (selectedFile == null) {
            return;
        }
        UploadAsDlg dlg = new UploadAsDlg(this.jftp, selectedFile);
        dlg.setLocationRelativeTo(this.jftp);
        dlg.setVisible(true);
        if (!dlg.isApproved()) {
            return;
        }
        final String fileName = dlg.getFileName();
        dlg.dispose();
        System.gc();
        session.clearAbortFlag();
        session.setBusy(true);
        new SwingWorker(){

            public Object construct() {
                session.upload(session.getLocalWorkingDirectory(), session.getRemoteWorkingDirectory(), selectedFile, fileName);
                return null;
            }

            public void finished() {
                session.setBusy(false);
                session.refreshRemotePane();
            }
        }.start();
    }
}

