/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.actions;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.SwingWorker;
import com.myjavaworld.jftp.FTPSession;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.jftp.ZipAndUploadDlg;
import com.myjavaworld.zip.Zip;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

public class ZipAndUploadAction
implements ActionListener {
    private JFTP jftp = null;
    private static ZipAndUploadAction instance = null;

    private ZipAndUploadAction(JFTP jftp) {
        this.jftp = jftp;
    }

    public static synchronized ZipAndUploadAction getInstance(JFTP jftp) {
        if (instance == null && instance == null) {
            instance = new ZipAndUploadAction(jftp);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent evt) {
        this.zipAndUpload();
    }

    private void zipAndUpload() {
        final FTPSession session = this.jftp.getCurrentSession();
        if (session == null || !session.isConnected()) {
            return;
        }
        final LocalFile[] selectedFiles = session.getSelectedLocalFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        ZipAndUploadDlg dlg = new ZipAndUploadDlg(this.jftp);
        dlg.setLocationRelativeTo(this.jftp);
        dlg.setVisible(true);
        if (!dlg.isApproved()) {
            return;
        }
        final String fileName = dlg.getFileName();
        final boolean deleteAfterUpload = dlg.getDeleteOption();
        final File file = dlg.getZipFile();
        dlg.dispose();
        System.gc();
        if (file == null) {
            return;
        }
        session.clearAbortFlag();
        session.setBusy(true);
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                Zip zip = null;
                try {
                    zip = new Zip(file);
                    zip.addZipListener(session);
                    zip.setFilter(session.getLocalFileFilter());
                    zip.addProgressListener(session);
                    zip.setRelativeTo(session.getLocalWorkingDirectory().getFile());
                    zip.open();
                    for (int i = 0; i < selectedFiles.length; ++i) {
                        zip.addEntry(selectedFiles[i].getFile());
                    }
                    zip.close();
                    session.upload(new LocalFile(zip.getFile()), fileName);
                    if (deleteAfterUpload) {
                        zip.getFile().delete();
                    }
                }
                catch (Throwable t) {
                    GUIUtil.showError((Component)ZipAndUploadAction.this.jftp, t);
                }
                finally {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            }

            public void finished() {
                session.setBusy(false);
                session.resetStatusBar();
                session.refreshRemotePane();
                session.refreshLocalPane();
            }
        }.start();
    }
}

