/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.ssl.CertificatePane;
import com.myjavaworld.jftp.ssl.KeyStoreManager;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.util.ResourceBundle;
import javax.swing.Box;

public class CertificateDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ssl.CertificateDlg");
    private static final String HELP_ID = "security.viewCertificate";
    private MButton butInstall = null;
    private MButton butClose = null;
    private MButton butHelp = null;
    private boolean installable = false;
    private Certificate[] chain = null;

    public CertificateDlg(Frame parent, Certificate certificate) {
        this(parent, new Certificate[]{certificate});
    }

    public CertificateDlg(Frame parent, Certificate[] chain) {
        this(parent, chain, false);
    }

    public CertificateDlg(Frame parent, Certificate[] chain, boolean installable) {
        super(parent);
        this.chain = chain;
        this.installable = installable;
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butClose) {
            this.setVisible(false);
        } else if (evt.getSource() == this.butInstall) {
            try {
                KeyStoreManager.addServerCertificate(this.chain);
                this.setVisible(false);
            }
            catch (Exception exp) {
                GUIUtil.showError((Component)this, exp);
            }
        }
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(12, 12, 12, 12);
        c.fill = 1;
        this.getContentPane().add((Component)new CertificatePane(this.chain), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 14;
        c.insets = new Insets(6, 12, 12, 12);
        c.fill = 0;
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butInstall = new MButton(resources.getString("text.install"));
        this.butInstall.addActionListener(this);
        this.butClose = new MButton(CommonResources.getString("text.close"));
        this.butClose.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butClose);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        if (this.installable) {
            panel.add(this.butInstall);
            panel.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        panel.add(this.butClose);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

