/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.gui.DateCellRenderer;
import com.myjavaworld.gui.GUIUtil;
import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MScrollPane;
import com.myjavaworld.gui.MTable;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.ssl.CertificateDlg;
import com.myjavaworld.jftp.ssl.CertificateTableModel;
import com.myjavaworld.jftp.ssl.KeyStoreManager;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CertificateManagerDlg
extends MDialog
implements ActionListener,
ListSelectionListener,
ChangeListener,
MouseListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ssl.CertificateManagerDlg");
    private static final String HELP_ID = "security.certificatesManager";
    JTabbedPane tabs = null;
    private MTable serverCertificatesTable = null;
    private CertificateTableModel serverCertificatesTableModel = null;
    private MTable clientCertificatesTable = null;
    private CertificateTableModel clientCertificatesTableModel = null;
    private MButton butView = null;
    private MButton butDelete = null;
    private MButton butImport = null;
    private MButton butClose = null;
    private MButton butHelp = null;
    private Frame parent = null;
    private Action deleteCertificatesAction = null;

    public CertificateManagerDlg(Frame parent) {
        super(parent);
        this.parent = parent;
        this.setTitle(resources.getString("title.dialog"));
        this.setModal(true);
        this.setResizable(true);
        this.deleteCertificatesAction = new DeleteCertificateAction();
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butView) {
            this.viewCertificate();
        } else if (evt.getSource() == this.butClose) {
            this.setVisible(false);
        } else if (evt.getSource() == this.butImport) {
            this.importCertificates();
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.serverCertificatesTable.getSelectionModel()) {
            int selectionCount = this.serverCertificatesTable.getSelectedRowCount();
            this.butView.setEnabled(selectionCount == 1);
            this.butDelete.setEnabled(selectionCount > 0);
        } else if (evt.getSource() == this.clientCertificatesTable.getSelectionModel()) {
            int selectionCount = this.clientCertificatesTable.getSelectedRowCount();
            this.butView.setEnabled(selectionCount == 1);
            this.butDelete.setEnabled(selectionCount > 0);
        }
    }

    public void stateChanged(ChangeEvent evt) {
        if (this.tabs.getSelectedIndex() == 0) {
            int selectionCount = this.serverCertificatesTable.getSelectedRowCount();
            this.butView.setEnabled(selectionCount == 1);
            this.butDelete.setEnabled(selectionCount > 0);
        } else if (this.tabs.getSelectedIndex() == 1) {
            int selectionCount = this.clientCertificatesTable.getSelectedRowCount();
            this.butView.setEnabled(selectionCount == 1);
            this.butDelete.setEnabled(selectionCount > 0);
        }
    }

    public void windowOpened(WindowEvent evt) {
        this.butView.setEnabled(false);
        this.butDelete.setEnabled(false);
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int row;
            if (evt.getSource() == this.serverCertificatesTable) {
                int row2 = this.serverCertificatesTable.rowAtPoint(evt.getPoint());
                if (row2 >= 0) {
                    this.viewServerCertificate();
                }
            } else if (evt.getSource() == this.clientCertificatesTable && (row = this.serverCertificatesTable.rowAtPoint(evt.getPoint())) >= 0) {
                this.viewClientCertificate();
            }
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    protected void escape() {
        this.butClose.doClick();
    }

    private void viewCertificate() {
        if (this.tabs.getSelectedIndex() == 0) {
            this.viewServerCertificate();
        } else {
            this.viewClientCertificate();
        }
    }

    private void viewServerCertificate() {
        int selectedRow = this.serverCertificatesTable.getSelectedRow();
        if (selectedRow >= 0) {
            Certificate certificate = this.serverCertificatesTableModel.getCertificateAt(selectedRow);
            CertificateDlg dlg = new CertificateDlg(this.parent, certificate);
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
            dlg.dispose();
        }
    }

    private void viewClientCertificate() {
        int selectedRow = this.clientCertificatesTable.getSelectedRow();
        if (selectedRow >= 0) {
            Certificate certificate = this.clientCertificatesTableModel.getCertificateAt(selectedRow);
            CertificateDlg dlg = new CertificateDlg(this.parent, certificate);
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
            dlg.dispose();
        }
    }

    private void deleteCertificates() {
        if (this.tabs.getSelectedIndex() == 0) {
            this.deleteServerCertificates();
        } else {
            this.deleteClientCertificates();
        }
    }

    private void deleteServerCertificates() {
        int[] selectedRows = this.serverCertificatesTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        int option = GUIUtil.showConfirmation(this, resources.getString("confirm.deleteServerCertificates"));
        if (option != 0) {
            return;
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            String alias = this.serverCertificatesTableModel.getAliasAt(selectedRows[i]);
            try {
                KeyStoreManager.deleteServerCertificate(alias);
                continue;
            }
            catch (Exception exp) {
                System.err.println(exp);
            }
        }
        try {
            this.serverCertificatesTableModel.setKeyStore(KeyStoreManager.getServerCertificateStore());
        }
        catch (Exception exp) {
            System.err.println(exp);
        }
    }

    private void deleteClientCertificates() {
        int[] selectedRows = this.clientCertificatesTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        int option = GUIUtil.showConfirmation(this, resources.getString("confirm.deleteClientCertificates"));
        if (option != 0) {
            return;
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            String alias = this.clientCertificatesTableModel.getAliasAt(selectedRows[i]);
            try {
                KeyStoreManager.deleteClientCertificate(alias);
                continue;
            }
            catch (Exception exp) {
                System.err.println(exp);
            }
        }
        try {
            this.clientCertificatesTableModel.setKeyStore(KeyStoreManager.getClientCertificateStore());
        }
        catch (Exception exp) {
            System.err.println(exp);
        }
    }

    private void importCertificates() {
        if (this.tabs.getSelectedIndex() == 0) {
            this.importServerCertificates();
        } else {
            this.importClientCertificates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importServerCertificates() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(CommonResources.getString("title.selectFile"));
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        FileInputStream fin = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            fin = new FileInputStream(selectedFile);
            Collection<? extends Certificate> certificates = cf.generateCertificates(fin);
            for (Certificate certificate : certificates) {
                KeyStoreManager.addServerCertificate(new Certificate[]{certificate});
            }
            this.serverCertificatesTableModel.setKeyStore(KeyStoreManager.getServerCertificateStore());
        }
        catch (Exception exp) {
            GUIUtil.showError((Component)this, exp);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exp) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importClientCertificates() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(CommonResources.getString("title.selectFile"));
        chooser.setApproveButtonText(resources.getString("text.import"));
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        FileInputStream fin = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            fin = new FileInputStream(selectedFile);
            Collection<? extends Certificate> certificates = cf.generateCertificates(fin);
            for (Certificate certificate : certificates) {
                KeyStoreManager.addClientCertificate(new Certificate[]{certificate});
            }
            this.clientCertificatesTableModel.setKeyStore(KeyStoreManager.getClientCertificateStore());
        }
        catch (Exception exp) {
            GUIUtil.showError((Component)this, exp);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exp) {}
        }
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.tabs = new JTabbedPane();
        this.tabs.add(resources.getString("text.serverCertificates"), this.getServerCertificatesTab());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.getContentPane().add((Component)this.tabs, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 14;
        c.insets = new Insets(6, 12, 12, 12);
        c.fill = 0;
        this.getContentPane().add(this.getCommandButtons(), c);
        this.tabs.addChangeListener(this);
        InputMap inputMap = this.serverCertificatesTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteCertificate");
        ActionMap actionMap = this.serverCertificatesTable.getActionMap();
        actionMap.put("deleteCertificate", this.deleteCertificatesAction);
    }

    private Component getServerCertificatesTab() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        try {
            this.serverCertificatesTableModel = new CertificateTableModel(KeyStoreManager.getServerCertificateStore());
            this.serverCertificatesTable = new MTable(this.serverCertificatesTableModel);
            this.serverCertificatesTable.setAutoResizeMode(0);
            this.serverCertificatesTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.serverCertificatesTable.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.serverCertificatesTable.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.serverCertificatesTable.getColumnModel().getColumn(3).setPreferredWidth(150);
            this.serverCertificatesTable.setDefaultRenderer(Date.class, new DateCellRenderer(JFTP.prefs.getDateFormat(), JFTP.prefs.getTimeFormat()));
        }
        catch (Exception exp) {
            System.err.println(exp);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(12, 12, 12, 12);
        c.fill = 1;
        MScrollPane scrollPane = new MScrollPane(this.serverCertificatesTable);
        scrollPane.getViewport().setPreferredSize(new Dimension(600, 300));
        panel.add((Component)scrollPane, c);
        this.serverCertificatesTable.getSelectionModel().addListSelectionListener(this);
        this.serverCertificatesTable.addMouseListener(this);
        return panel;
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butView = new MButton(CommonResources.getString("text.view"));
        this.butView.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butView);
        this.butDelete = new MButton(CommonResources.getString("text.delete"));
        this.butDelete.addActionListener(this.deleteCertificatesAction);
        this.butImport = new MButton(resources.getString("text.import"));
        this.butImport.addActionListener(this);
        this.butClose = new MButton(CommonResources.getString("text.close"));
        this.butClose.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butView);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butDelete);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butImport);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butClose);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }

    class DeleteCertificateAction
    extends AbstractAction {
        DeleteCertificateAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            CertificateManagerDlg.this.deleteCertificates();
        }
    }
}

