/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.ssl.DNParser;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CertificatePane
extends JPanel {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ssl.CertificatePane");
    private MLabel tfVersion = null;
    private MLabel tfSerialNumber = null;
    private MLabel tfValidity = null;
    private MLabel tfSignatureAlgorithm = null;
    private MLabel labIssuerOrganization = null;
    private MLabel labIssuerOrganizationUnit = null;
    private MLabel labIssuerCommonName = null;
    private MLabel labIssuerCountry = null;
    private MLabel labSubjectOrganization = null;
    private MLabel labSubjectOrganizationUnit = null;
    private MLabel labSubjectCommonName = null;
    private MLabel labSubjectCountry = null;
    private Certificate[] chain = null;

    public CertificatePane() {
        this((Certificate[])null);
    }

    public CertificatePane(Certificate[] chain) {
        this.setLayout(new GridBagLayout());
        this.initComponents();
        this.setCertificateChain(chain);
    }

    public void setCertificateChain(Certificate[] chain) {
        this.chain = chain;
        if (chain != null) {
            this.populateScreen();
        }
    }

    public Certificate[] getCertificateChain() {
        return this.chain;
    }

    private void populateScreen() {
        this.populateGeneralPanel();
        this.populateIssuerPanel();
        this.populateSubjectPanel();
    }

    private void populateGeneralPanel() {
        X509Certificate certificate = (X509Certificate)this.chain[0];
        this.tfVersion.setText("V" + certificate.getVersion());
        this.tfSerialNumber.setText(certificate.getSerialNumber().toString());
        DateFormat formatter = DateFormat.getDateTimeInstance(JFTP.prefs.getDateFormat(), JFTP.prefs.getTimeFormat());
        String validFrom = formatter.format(certificate.getNotBefore());
        String validTo = formatter.format(certificate.getNotAfter());
        MessageFormat mf = new MessageFormat(resources.getString("value.validity"));
        String[] args = new String[]{validFrom, validTo};
        this.tfValidity.setText(mf.format(args));
        this.tfSignatureAlgorithm.setText(certificate.getSigAlgName());
    }

    private void populateIssuerPanel() {
        X509Certificate certificate = (X509Certificate)this.chain[0];
        String dn = certificate.getIssuerDN().getName();
        DNParser parser = new DNParser(dn);
        this.labIssuerOrganization.setText(parser.getParameter("O"));
        this.labIssuerOrganizationUnit.setText(parser.getParameter("OU"));
        this.labIssuerCommonName.setText(parser.getParameter("CN"));
        this.labIssuerCountry.setText(parser.getParameter("C"));
    }

    private void populateSubjectPanel() {
        X509Certificate certificate = (X509Certificate)this.chain[0];
        String dn = certificate.getSubjectDN().getName();
        DNParser parser = new DNParser(dn);
        this.labSubjectOrganization.setText(parser.getParameter("O"));
        this.labSubjectOrganizationUnit.setText(parser.getParameter("OU"));
        this.labSubjectCommonName.setText(parser.getParameter("CN"));
        this.labSubjectCountry.setText(parser.getParameter("C"));
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 12, 0);
        this.add(this.getGeneralPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 12, 0);
        this.add(this.getIssuerPanel(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        this.add(this.getSubjectPanel(), c);
    }

    private Component getGeneralPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.general")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(6, 6, 6, 12);
        MLabel labVersion = new MLabel(resources.getString("text.version"));
        panel.add((Component)labVersion, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(6, 0, 6, 6);
        this.tfVersion = new MLabel();
        panel.add((Component)this.tfVersion, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labSerialNumber = new MLabel(resources.getString("text.serialNumber"));
        panel.add((Component)labSerialNumber, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.tfSerialNumber = new MLabel();
        panel.add((Component)this.tfSerialNumber, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labValidity = new MLabel(resources.getString("text.validity"));
        panel.add((Component)labValidity, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.tfValidity = new MLabel();
        panel.add((Component)this.tfValidity, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labSignatureAlgorithm = new MLabel(resources.getString("text.signatureAlgorithm"));
        panel.add((Component)labSignatureAlgorithm, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.tfSignatureAlgorithm = new MLabel();
        panel.add((Component)this.tfSignatureAlgorithm, c);
        return panel;
    }

    private Component getIssuerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.issuer")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(6, 6, 6, 12);
        MLabel labOrganization = new MLabel(resources.getString("text.organization"));
        panel.add((Component)labOrganization, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(6, 0, 6, 6);
        this.labIssuerOrganization = new MLabel();
        panel.add((Component)this.labIssuerOrganization, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labOrganizationUnit = new MLabel(resources.getString("text.organizationUnit"));
        panel.add((Component)labOrganizationUnit, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.labIssuerOrganizationUnit = new MLabel();
        panel.add((Component)this.labIssuerOrganizationUnit, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labCommonName = new MLabel(resources.getString("text.commonName"));
        panel.add((Component)labCommonName, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.labIssuerCommonName = new MLabel();
        panel.add((Component)this.labIssuerCommonName, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labCountry = new MLabel(resources.getString("text.country"));
        panel.add((Component)labCountry, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.labIssuerCountry = new MLabel();
        panel.add((Component)this.labIssuerCountry, c);
        return panel;
    }

    private Component getSubjectPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(resources.getString("title.subject")));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(6, 6, 6, 12);
        MLabel labOrganization = new MLabel(resources.getString("text.organization"));
        panel.add((Component)labOrganization, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(6, 0, 6, 6);
        this.labSubjectOrganization = new MLabel();
        panel.add((Component)this.labSubjectOrganization, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labOrganizationUnit = new MLabel(resources.getString("text.organizationUnit"));
        panel.add((Component)labOrganizationUnit, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.labSubjectOrganizationUnit = new MLabel();
        panel.add((Component)this.labSubjectOrganizationUnit, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labCommonName = new MLabel(resources.getString("text.commonName"));
        panel.add((Component)labCommonName, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.labSubjectCommonName = new MLabel();
        panel.add((Component)this.labSubjectCommonName, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 6, 6, 12);
        MLabel labCountry = new MLabel(resources.getString("text.country"));
        panel.add((Component)labCountry, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 6, 6);
        this.labSubjectCountry = new MLabel();
        panel.add((Component)this.labSubjectCountry, c);
        return panel;
    }
}

