/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.jftp.ssl.DNParser;
import com.myjavaworld.util.ResourceLoader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class CertificateTableModel
extends AbstractTableModel {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ssl.CertificateTableModel");
    private static final String[] COLUMN_NAMES = new String[]{resources.getString("text.subject"), resources.getString("text.issuer"), resources.getString("text.validFrom"), resources.getString("text.validTo")};
    private KeyStore keyStore = null;
    private List aliases = null;

    public CertificateTableModel(KeyStore keyStore) throws KeyStoreException {
        this.setKeyStore(keyStore);
    }

    public void setKeyStore(KeyStore keyStore) throws KeyStoreException {
        this.keyStore = keyStore;
        this.aliases = new ArrayList();
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            this.aliases.add(alias);
        }
        this.fireTableDataChanged();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public int getRowCount() {
        return this.aliases.size();
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        String alias = (String)this.aliases.get(row);
        try {
            X509Certificate certificate = (X509Certificate)this.keyStore.getCertificate(alias);
            if (col == 0) {
                String subjectDN = certificate.getSubjectDN().getName();
                String returnValue = DNParser.getParameter(subjectDN, "O");
                return returnValue == null ? "" : returnValue;
            }
            if (col == 1) {
                String issuerDN = certificate.getIssuerDN().getName();
                String returnValue = DNParser.getParameter(issuerDN, "O");
                return returnValue == null ? "" : returnValue;
            }
            if (col == 2) {
                return certificate.getNotBefore();
            }
            if (col == 3) {
                return certificate.getNotAfter();
            }
            return "";
        }
        catch (KeyStoreException exp) {
            return "Error reading certificate";
        }
    }

    public Class getColumnClass(int col) {
        if (col == 2 || col == 3) {
            return Date.class;
        }
        return Object.class;
    }

    public Certificate getCertificateAt(int row) {
        String alias = (String)this.aliases.get(row);
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public String getAliasAt(int row) {
        return (String)this.aliases.get(row);
    }
}

