/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.ssl.KeyStoreManager;
import java.net.Socket;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class JFTPKeyManager
implements X509KeyManager {
    private X509KeyManager km = null;

    public JFTPKeyManager() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(KeyStoreManager.getClientCertificateStore(), JFTP.prefs.getClientCertificateStorePassword());
        this.km = (X509KeyManager)kmf.getKeyManagers()[0];
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.km.getPrivateKey(alias);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.km.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.km.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.km.getServerAliases(keyType, issuers);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.km.chooseServerAlias(keyType, issuers, socket);
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.km.chooseClientAlias(keyType, issuers, socket);
    }
}

