/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.jftp.JFTP;
import com.myjavaworld.jftp.ssl.DNParser;
import com.myjavaworld.jftp.ssl.KeyStoreManager;
import com.myjavaworld.jftp.ssl.SecurityWarningDlg;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JFTPTrustManager
implements X509TrustManager {
    private JFTP jftp = null;
    private String hostName = null;
    private X509TrustManager tm = null;
    private X509Certificate[] chain = null;

    public JFTPTrustManager(JFTP jftp, String hostName) throws KeyStoreException, NoSuchAlgorithmException {
        this.jftp = jftp;
        this.hostName = hostName;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(KeyStoreManager.getServerCertificateStore());
        this.tm = (X509TrustManager)tmf.getTrustManagers()[0];
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tm.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.chain != null && Arrays.equals(chain, this.chain)) {
            return;
        }
        boolean validDate = this.isValidDate(chain);
        boolean validHost = this.isValidHost(chain);
        boolean trusted = this.isTrusted(chain);
        if (!(validDate && validHost && trusted)) {
            int userOption = SecurityWarningDlg.showDialog(this.jftp, chain, validDate, validHost, trusted);
            if (userOption != 1) {
                throw new CertificateException("No trusted certificate found. ");
            }
            this.chain = chain;
        } else {
            this.chain = chain;
        }
    }

    private boolean isValidDate(X509Certificate[] chain) {
        try {
            chain[0].checkValidity();
        }
        catch (CertificateNotYetValidException exp) {
            return false;
        }
        catch (CertificateException exp) {
            return false;
        }
        return true;
    }

    private boolean isValidHost(X509Certificate[] chain) {
        X509Certificate certificate = chain[0];
        String subjectDN = certificate.getSubjectDN().getName();
        DNParser parser = new DNParser(subjectDN);
        String commonName = parser.getParameter("CN");
        if (commonName != null) {
            return commonName.toUpperCase().equals(this.hostName.toUpperCase());
        }
        return false;
    }

    private boolean isTrusted(X509Certificate[] chain) {
        boolean trusted = false;
        try {
            KeyStore keyStore = KeyStoreManager.getServerCertificateStore();
            for (int i = chain.length - 1; i >= 0; --i) {
                if (keyStore.getCertificateAlias(chain[i]) == null) continue;
                trusted = true;
                break;
            }
        }
        catch (Exception e) {
            trusted = false;
        }
        return trusted;
    }
}

