/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.jftp.JFTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class KeyStoreManager {
    private static final String ALIAS_PREFIX = "JFTP";
    private static KeyStore serverCertificateStore = null;
    private static KeyStore clientCertificateStore = null;
    private static boolean inited = false;

    private static synchronized void init() throws KeyStoreException {
        File file = new File(JFTP.prefs.getServerCertificateStore());
        char[] password = JFTP.prefs.getServerCertificateStorePassword();
        serverCertificateStore = KeyStoreManager.getKeyStore(file, password);
        file = new File(JFTP.prefs.getClientCertificateStore());
        password = JFTP.prefs.getClientCertificateStorePassword();
        clientCertificateStore = KeyStoreManager.getKeyStore(file, password);
        inited = true;
    }

    public static synchronized KeyStore getServerCertificateStore() throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        return serverCertificateStore;
    }

    public static synchronized KeyStore getClientCertificateStore() throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        return clientCertificateStore;
    }

    public static synchronized void addServerCertificate(Certificate[] chain) throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        KeyStoreManager.addCertificate(serverCertificateStore, chain);
        KeyStoreManager.saveServerCertificateStore();
    }

    public static synchronized void addClientCertificate(Certificate[] chain) throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        KeyStoreManager.addCertificate(clientCertificateStore, chain);
        KeyStoreManager.saveClientCertificateStore();
    }

    public static synchronized void deleteServerCertificate(String alias) throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        KeyStoreManager.deleteCertificate(serverCertificateStore, alias);
        KeyStoreManager.saveServerCertificateStore();
    }

    public static synchronized void deleteClientCertificate(String alias) throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        KeyStoreManager.deleteCertificate(clientCertificateStore, alias);
        KeyStoreManager.saveClientCertificateStore();
    }

    private static synchronized KeyStore getKeyStore(String fileName, char[] password) throws KeyStoreException {
        return KeyStoreManager.getKeyStore(new File(fileName), password);
    }

    private static synchronized KeyStore getKeyStore(File file, char[] password) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fin = null;
        try {
            if (!file.exists()) {
                keyStore.load(null, password);
                KeyStoreManager.saveCertificateStore(file, password, keyStore);
            }
            fin = new FileInputStream(file);
            keyStore.load(fin, password);
        }
        catch (Exception exp) {
            throw new KeyStoreException(exp.toString());
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exp) {}
                fin = null;
            }
        }
        return keyStore;
    }

    private static synchronized void saveServerCertificateStore() throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        File file = new File(JFTP.prefs.getServerCertificateStore());
        char[] password = JFTP.prefs.getServerCertificateStorePassword();
        KeyStoreManager.saveCertificateStore(file, password, serverCertificateStore);
    }

    private static synchronized void saveClientCertificateStore() throws KeyStoreException {
        if (!inited) {
            KeyStoreManager.init();
        }
        File file = new File(JFTP.prefs.getClientCertificateStore());
        char[] password = JFTP.prefs.getClientCertificateStorePassword();
        KeyStoreManager.saveCertificateStore(file, password, clientCertificateStore);
    }

    private static synchronized void addCertificate(KeyStore keyStore, Certificate[] chain) throws KeyStoreException {
        if (chain == null || chain.length == 0) {
            return;
        }
        for (int i = 0; i < chain.length; ++i) {
            String alias = keyStore.getCertificateAlias(chain[i]);
            if (alias == null) {
                alias = KeyStoreManager.getNextAlias(keyStore);
            }
            keyStore.setCertificateEntry(alias, chain[i]);
        }
    }

    private static synchronized String getNextAlias(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        int maxAliasID = 1000;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!alias.toUpperCase().startsWith(ALIAS_PREFIX.toUpperCase()) || alias.length() <= ALIAS_PREFIX.length()) continue;
            try {
                int aliasID = Integer.parseInt(alias.substring(ALIAS_PREFIX.length()));
                maxAliasID = Math.max(maxAliasID, aliasID);
            }
            catch (NumberFormatException exp) {}
        }
        return ALIAS_PREFIX + ++maxAliasID;
    }

    private static synchronized void deleteCertificate(KeyStore keyStore, String alias) throws KeyStoreException {
        keyStore.deleteEntry(alias);
    }

    private static synchronized void saveCertificateStore(File file, char[] password, KeyStore keyStore) throws KeyStoreException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            keyStore.store(fout, password);
        }
        catch (Exception exp) {
            throw new KeyStoreException("Failed to save the certificate store: " + file);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exp) {}
                fout = null;
            }
        }
    }
}

