/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.jftp.ssl;

import com.myjavaworld.gui.MButton;
import com.myjavaworld.gui.MDialog;
import com.myjavaworld.gui.MLabel;
import com.myjavaworld.jftp.JFTPHelp2;
import com.myjavaworld.jftp.ssl.CertificateDlg;
import com.myjavaworld.util.CommonResources;
import com.myjavaworld.util.ResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SecurityWarningDlg
extends MDialog
implements ActionListener {
    private static ResourceBundle resources = ResourceLoader.getBundle("com.myjavaworld.jftp.ssl.SecurityWarningDlg");
    private static final String HELP_ID = "security.installCertificate";
    public static final int NO_OPTION = 0;
    public static final int YES_OPTION = 1;
    private MLabel labMainMessage = null;
    private MLabel labDateMessage = null;
    private MLabel labHostMessage = null;
    private MLabel labTrustMessage = null;
    private MLabel labQuestion = null;
    private MButton butViewCertificate = null;
    private MButton butYes = null;
    private MButton butNo = null;
    private MButton butHelp = null;
    private Frame parent = null;
    private Certificate[] chain = null;
    private boolean validDate = false;
    private boolean validHost = false;
    private boolean trusted = false;
    private int option = 0;

    public SecurityWarningDlg(Frame parent, Certificate[] chain, boolean validDate, boolean validHost, boolean trusted) {
        super(parent);
        this.parent = parent;
        this.chain = chain;
        this.validDate = validDate;
        this.validHost = validHost;
        this.trusted = trusted;
        this.option = 0;
        this.setTitle(resources.getString("title.dialog"));
        this.getAccessibleContext().setAccessibleDescription("dialog.description");
        this.setModal(true);
        JFTPHelp2.getInstance().enableHelpKey(this.getRootPane(), HELP_ID);
        this.initComponents();
        this.pack();
    }

    public static int showDialog(Component invoker, Certificate[] chain, boolean validDate, boolean validHost, boolean trusted) {
        Frame parent = null;
        parent = invoker instanceof Frame ? (Frame)invoker : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, invoker);
        SecurityWarningDlg dlg = new SecurityWarningDlg(parent, chain, validDate, validHost, trusted);
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        return dlg.option;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.butViewCertificate) {
            CertificateDlg dlg = new CertificateDlg(this.parent, this.chain, true);
            dlg.setLocationRelativeTo(this);
            dlg.setVisible(true);
            dlg.dispose();
            return;
        }
        if (evt.getSource() == this.butYes) {
            this.option = 1;
        }
        this.setVisible(false);
        this.dispose();
    }

    protected void escape() {
        this.butNo.doClick();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        String message = null;
        Icon warningIcon = UIManager.getIcon("OptionPane.warningIcon");
        Icon infoIcon = UIManager.getIcon("OptionPane.informationIcon");
        message = resources.getString("text.main");
        this.labMainMessage = new MLabel(message);
        this.labMainMessage.setIcon(warningIcon);
        message = this.validDate ? resources.getString("text.validDate") : resources.getString("text.invalidDate");
        this.labDateMessage = new MLabel(message);
        this.labDateMessage.setIcon(this.validDate ? infoIcon : warningIcon);
        message = this.validHost ? resources.getString("text.validHost") : resources.getString("text.invalidHost");
        this.labHostMessage = new MLabel(message);
        this.labHostMessage.setIcon(this.validHost ? infoIcon : warningIcon);
        message = this.trusted ? resources.getString("text.trustedCertificate") : resources.getString("text.untrustedCertificate");
        this.labTrustMessage = new MLabel(message);
        this.labTrustMessage.setIcon(this.trusted ? infoIcon : warningIcon);
        this.labQuestion = new MLabel(resources.getString("text.question"));
        this.butViewCertificate = new MButton(resources.getString("text.viewCertificate"));
        this.butViewCertificate.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(12, 12, 12, 12);
        this.getContentPane().add((Component)this.labMainMessage, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)this.labDateMessage, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)this.labHostMessage, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)this.labTrustMessage, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 12, 12, 12);
        this.getContentPane().add((Component)this.labQuestion, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 14;
        c.insets = new Insets(0, 12, 12, 12);
        c.fill = 0;
        this.getContentPane().add((Component)this.butViewCertificate, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 14;
        c.insets = new Insets(6, 12, 12, 12);
        c.fill = 0;
        this.getContentPane().add(this.getCommandButtons(), c);
    }

    private Component getCommandButtons() {
        Box panel = new Box(0);
        this.butYes = new MButton(CommonResources.getString("text.yes"));
        this.butYes.addActionListener(this);
        this.getRootPane().setDefaultButton(this.butYes);
        this.butNo = new MButton(CommonResources.getString("text.no"));
        this.butNo.addActionListener(this);
        this.butHelp = new MButton(CommonResources.getString("text.help"));
        JFTPHelp2.getInstance().enableHelp(this.butHelp, HELP_ID);
        panel.add(this.butYes);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butNo);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.butHelp);
        return panel;
    }
}

