/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.util;

import com.myjavaworld.util.FileChangeEvent;
import com.myjavaworld.util.FileChangeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class FileChangeMonitor
implements ActionListener {
    private Hashtable filesToMonitor = new Hashtable();
    private EventListenerList listenerList = new EventListenerList();
    private Timer timer = null;

    public synchronized void add(File file) {
        this.filesToMonitor.put(file, new Long(file.lastModified()));
        if (this.timer == null && this.timer == null) {
            this.timer = new Timer(1000, this);
            this.timer.start();
        }
    }

    public void remove(File file) {
        this.filesToMonitor.remove(file);
    }

    public void addFileChangeListener(FileChangeListener listener) {
        this.listenerList.add(FileChangeListener.class, listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        this.listenerList.remove(FileChangeListener.class, listener);
    }

    public void stopMonitor() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Enumeration keys = this.filesToMonitor.keys();
        while (keys.hasMoreElements()) {
            File file = (File)keys.nextElement();
            Long prevDate = (Long)this.filesToMonitor.get(file);
            Long currDate = new Long(file.lastModified());
            if (currDate.compareTo(prevDate) <= 0) continue;
            FileChangeEvent fce = new FileChangeEvent(this, file, prevDate, currDate);
            this.fireFileChanged(fce);
            this.filesToMonitor.put(file, new Long(file.lastModified()));
        }
    }

    protected void fireFileChanged(FileChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FileChangeListener.class) continue;
            ((FileChangeListener)listeners[i + 1]).fileChanged(evt);
        }
    }
}

