/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceLoader {
    public static ResourceBundle getBundle(String baseName) {
        return ResourceLoader.getBundle(baseName, Locale.getDefault());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        try {
            return ResourceBundle.getBundle(baseName, locale);
        }
        catch (MissingResourceException exp) {
            exp.printStackTrace();
            ResourceLoader.fireResourceNotFound(baseName, locale);
            return null;
        }
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        try {
            return ResourceBundle.getBundle(baseName, locale, loader);
        }
        catch (MissingResourceException exp) {
            exp.printStackTrace();
            ResourceLoader.fireResourceNotFound(baseName, locale);
            return null;
        }
    }

    private static void fireResourceNotFound(String baseName, Locale locale) {
        System.err.println("Resource " + baseName + " Not Found for Locale " + locale + ". ");
        System.exit(1);
    }
}

