/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.zip;

import com.myjavaworld.util.ProgressEvent;
import com.myjavaworld.util.ProgressListener;
import com.myjavaworld.zip.ZipEvent;
import com.myjavaworld.zip.ZipListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.event.EventListenerList;

public class Unzip {
    private File file = null;
    private File targetDirectory = null;
    private ZipFile zipFile = null;
    private EventListenerList listenerList = null;

    public Unzip(File file) {
        this.file = file;
        this.targetDirectory = file.getParentFile();
        this.listenerList = new EventListenerList();
    }

    public File getFile() {
        return this.file;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void addZipListener(ZipListener l) {
        this.listenerList.add(ZipListener.class, l);
    }

    public void removeZipListener(ZipListener l) {
        this.listenerList.remove(ZipListener.class, l);
    }

    public void addProgressListener(ProgressListener l) {
        this.listenerList.add(ProgressListener.class, l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listenerList.remove(ProgressListener.class, l);
    }

    protected void fireBeginFileEvent(File file) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ZipListener.class) continue;
            ((ZipListener)listeners[i + 1]).beginFile(new ZipEvent(this, 2, file.getName()));
        }
    }

    protected void fireEndFileEvent(File file) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ZipListener.class) continue;
            ((ZipListener)listeners[i + 1]).endFile(new ZipEvent(this, 2, file.getName()));
        }
    }

    protected void fireProgressEvent(int progress) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProgressListener.class) continue;
            ((ProgressListener)listeners[i + 1]).progressChanged(new ProgressEvent(this, progress));
        }
    }

    public void open() throws ZipException, IOException {
        if (this.zipFile != null) {
            throw new IllegalStateException("ZipFile is already open");
        }
        this.zipFile = new ZipFile(this.file);
    }

    public void close() throws IOException {
        if (this.zipFile == null) {
            throw new IllegalStateException("ZipFile is not open or is already closed");
        }
        this.zipFile.close();
    }

    public void unzip() throws IOException {
        if (this.zipFile == null) {
            throw new IllegalStateException("ZipFile is not open");
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(this.targetDirectory, entry.getName());
                if (dir.exists()) continue;
                dir.mkdirs();
                dir.setLastModified(entry.getTime());
                continue;
            }
            this.unzipFile(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipFile(ZipEntry entry) throws IOException {
        File target = new File(this.targetDirectory, entry.getName());
        this.fireBeginFileEvent(target);
        File parentDir = target.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedInputStream bin = null;
        FilterOutputStream bout = null;
        int bufferSize = 16384;
        byte[] buffer = new byte[16384];
        int bytesRead = 0;
        long totalBytesRead = 0L;
        try {
            bin = new BufferedInputStream(this.zipFile.getInputStream(entry), 16384);
            bout = new BufferedOutputStream(new FileOutputStream(target), 16384);
            while ((bytesRead = bin.read(buffer)) != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, bytesRead);
                int progress = (int)((totalBytesRead += (long)bytesRead) * 100L / entry.getSize());
                this.fireProgressEvent(progress);
            }
        }
        finally {
            this.fireEndFileEvent(this.file);
            if (bout != null) {
                bout.close();
            }
            if (bin != null) {
                bin.close();
            }
        }
    }
}

