/*
 * Decompiled with CFR 0.152.
 */
package com.myjavaworld.zip;

import com.myjavaworld.jftp.LocalFile;
import com.myjavaworld.util.Filter;
import com.myjavaworld.util.ProgressEvent;
import com.myjavaworld.util.ProgressListener;
import com.myjavaworld.zip.ZipEvent;
import com.myjavaworld.zip.ZipListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;

public class Zip {
    private File file = null;
    private String relativeTo = null;
    private ZipOutputStream zout = null;
    private EventListenerList listenerList = null;
    private Filter filter = null;

    public Zip(File file) {
        this.file = file;
        this.listenerList = new EventListenerList();
    }

    public File getFile() {
        return this.file;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void addZipListener(ZipListener l) {
        this.listenerList.add(ZipListener.class, l);
    }

    public void removeZipListener(ZipListener l) {
        this.listenerList.remove(ZipListener.class, l);
    }

    public void addProgressListener(ProgressListener l) {
        this.listenerList.add(ProgressListener.class, l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listenerList.remove(ProgressListener.class, l);
    }

    protected void fireBeginFileEvent(File file) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ZipListener.class) continue;
            ((ZipListener)listeners[i + 1]).beginFile(new ZipEvent(this, 1, file.getName()));
        }
    }

    protected void fireEndFileEvent(File file) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ZipListener.class) continue;
            ((ZipListener)listeners[i + 1]).endFile(new ZipEvent(this, 1, file.getName()));
        }
    }

    protected void fireProgressEvent(int progress) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProgressListener.class) continue;
            ((ProgressListener)listeners[i + 1]).progressChanged(new ProgressEvent(this, progress));
        }
    }

    public File getRelativeTo() {
        return new File(this.relativeTo);
    }

    public void setRelativeTo(File relativeTo) {
        try {
            this.relativeTo = relativeTo.getCanonicalPath();
        }
        catch (IOException exp) {
            this.relativeTo = relativeTo.getAbsolutePath();
        }
    }

    public void open() throws IOException {
        this.zout = new ZipOutputStream(new FileOutputStream(this.file));
    }

    public void close() throws IOException {
        if (this.zout != null) {
            this.zout.close();
        }
        this.zout = null;
    }

    public void addEntry(File file) throws IOException {
        if (this.zout == null) {
            throw new IllegalStateException("Zip File was never opened or is already closed. ");
        }
        if (file.equals(this.file)) {
            return;
        }
        ZipEntry entry = new ZipEntry(this.computeEntryName(file));
        entry.setTime(file.lastModified());
        this.zout.putNextEntry(entry);
        if (file.isFile()) {
            this.addFile(file);
            this.zout.closeEntry();
        } else if (file.isDirectory()) {
            this.zout.closeEntry();
            LocalFile[] children = new LocalFile(file).list(this.filter);
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this.addEntry(children[i].getFile());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File file) throws IOException {
        this.fireBeginFileEvent(file);
        int bufferSize = 16384;
        byte[] buffer = new byte[16384];
        int bytesRead = 0;
        long fileSize = file.length();
        long totalBytesRead = 0L;
        BufferedInputStream bin = null;
        try {
            bin = new BufferedInputStream(new FileInputStream(file));
            while ((bytesRead = bin.read(buffer)) != -1) {
                this.zout.write(buffer, 0, bytesRead);
                int progress = (int)((totalBytesRead += (long)bytesRead) * 100L / fileSize);
                this.fireProgressEvent(progress);
            }
        }
        finally {
            this.fireEndFileEvent(file);
            if (bin != null) {
                bin.close();
            }
        }
    }

    private String computeEntryName(File file) {
        String entryName = null;
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException exp) {
            path = file.getAbsolutePath();
        }
        entryName = this.relativeTo == null ? path : path.substring(this.relativeTo.length());
        if (entryName.startsWith(File.separator)) {
            entryName = entryName.substring(1);
        }
        if (File.separatorChar != '/') {
            entryName = entryName.replace(File.separatorChar, '/');
        }
        if (file.isDirectory()) {
            entryName = entryName + "/";
        }
        return entryName;
    }
}

