JFTP - The Universal FTP Client
===============================

Introduction
------------

JFTP is a graphical FTP (File Transfer Protocol) client software for 
transferring files from one computer to another over TCP/IP networks such as 
Internet.

JFTP can connect to any system that has a valid Internet address and an FTP 
server program, allowing you to transfer files between a wide variety of 
systems, including Windows, Mac OS X, Linux, UNIX and IBM i(AS/400) systems.

JFTP integrates the most widely used and widely accepted security mechanism, 
SSL (Secured Sockets Layer), to securely transfer your business critical and 
sensitive data.

JFTP is written entirely in Java(tm), meaning, it can run on a wide variety of 
platforms such as Windows, Mac OS X, Linux, Solaris, HP-UX, OS/2, UNIX or any 
other platform with a compatible JVM (Java Virtual Machine). 

Features
--------

###"The Universal FTP Client"

A "true" Universal FTP Client. JFTP can be installed and run on a wide variety 
of platforms such as:

* Windows 
* Mac OS X
* Linux
* Solaris
* HP-UX
* OS/2
* Other UNIX flavors
* Any other platform with a compatible Java Runtime Environment

###Security

JFTP integrates the most widely used and widely accepted security mechanism, 
SSL (Secured Sockets Layer), to securely transfer your business critical and 
sensitive data.

* Support for SSL 3.0 and TLS 1.0, 1.1 and 1.2
* Supports several cryptographic algorithms such as RSA, AES, RC4, DES, Triple 
  DES, Diffie-Hellman and DSA
* Support for both Explicit and Implicit SSL connections
* Option of using SSL if it is supported by the FTP server

###File Filters

File filters give you the ability to decide what all files may be listed, 
uploaded, downloaded or deleted with in JFTP. You can set up either inclusion 
or exclusion filters on local and/or remote files based on a variety of 
criteria such as:

* File name pattern using regular expressions
* Modification date of the files
* Attributes of the files (if a file is hidden or not)

Using file filters, uploading all the files in your site that were modified on 
a specific date is as easy as a click of a mouse. No more need to spend time 
in picking up individual files in several directories of your web site.

###Transfers

* Download files and/or directories. Directories will be processed recursively
* Download As option to download a single file or directory (and its contents) 
  as a different name
* Download and Unzip option to automatically unzip downloaded zip files
* Upload files and/or directories. Directories will be processed recursively
* Upload As option to upload a single file or directory (and its contents) as 
  a different name
* Zip and Upload option to zip one or more files and/or directories and upload 
  the resulting zip file
* Filtered transfers

###Simultaneous FTP Sessions

JFTP allows you to work with multiple FTP sites simultaneously. Each session 
will create a new Tab making it easy to switch between sessions.

###Connect Quickly and Easily

Well thought-out design allows you to connect to your FTP site quickly and 
easily. You can configure both simple and advanced connection parameters, all 
through one easy-to-use connection dialog.

###Advanced Connection Options

JFTP allows you to specify various advanced connection parameters such as:

* Whether to use plain FTP connection or secured FTP connection
* Ability to provide an "Account" name for login. Most FTP servers just use 
  user name and password for login, but, some require account name to be 
  specified for login.
* Option of encrypting just the command channel to securely transmit the 
  password over the network
* Specify initial local and remote working directories to set, upon a 
  successful login
* Support for both passive (default) and active data transfers
* Allows you to execute raw FTP commands (standard or custom) soon after log in

###Proxy/Firewall

JFTP gives you the ability to connect through proxy servers and firewalls.

* Supports SOCKS proxy (both version 4 and version 5)
* Automatic detection of SOCKS version
* Supports SOCKS authentication

###Certificate Manager

JFTP comes with a built-in certificate manager to manage all your trusted 
certificates. Certificates are used to establish secured FTP connections. With 
JFTP's certificate manger, you can -

* Import certificates in to your trusted certificates database
* View details of a certificate
* Delete certificates from your trusted certificates database

###Manage your Favorite FTP Sites

JFTP allows you to store the connection parameters for the FTP sites that you 
frequently work with. With JFTP, connecting to your favorite FTP site is just 
one click away! In addition, for added security, JFTP stores all your favorite 
site definitions in encrypted format.

###Remote File Tasks

* Browse through the file system of your FTP site
* Open/Edit remote files directly using associated applications, modify them 
  and save them back to the FTP server 
* Print remote files using associated applications 
* Filter files based on their name pattern and/or modification date
* Create new directories
* Create new files
* Move/Rename files and directories
* Delete files and directories
* View or change permissions of a file or a directory
* Change the permissions of a directory and all of its children
* Execute standard or custom FTP commands
* Sort directory listing by name, type, size or last modified date

###Local File Tasks

* Browse through the file system of your PC and computers on your network
* Open/Edit local files using associated applications 
* Print local files using associated applications 
* Filter files based on their name pattern, modification date and/or attributes
* Create new directories
* Create new files
* Move/Rename files and directories
* Delete files and directories
* View attributes of a file or directory
* Sort directory listing by name, type, size or last modified date

###Auto-Detection of Transfer Type

JFTP automatically detects the transfer type (ASCII or Binary) to use for a 
specific file based on its extension. This feature is very useful when you are 
transferring hundreds or thousands of files of different types, in which case 
manually setting the transfer type is impossible.

###Internationalization and Localization

Support for Internationalization and Localization. This means JFTP supports 
multiple languages and Locale specific data such as dates and numbers. You can 
install as many language packs as you wish and use the language of your 
choice. The current version of JFTP bundles the following language packs:

* English
* Chinese (Traditional) 
* German 
